/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.newfile;

import com.intellij.javascript.flex.mxml.schema.ClassBackedElementDescriptor;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.actions.newfile.CreateFlexSkinDialog;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.fixes.ActionScriptCreateClassOrInterfaceFix;
import com.intellij.lang.javascript.validation.fixes.CreateMxmlFileIntentionBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFlexSkinIntention
extends CreateMxmlFileIntentionBase {
    public CreateFlexSkinIntention(String skinFqn, @NotNull PsiElement element) {
        if (element == null) {
            CreateFlexSkinIntention.$$$reportNull$$$0(0);
        }
        super(skinFqn, element);
    }

    @NotNull
    public String getText() {
        String string = FlexBundle.message("create.skin", this.myClassName);
        if (string == null) {
            CreateFlexSkinIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected Pair<String, PsiDirectory> getFileTextAndDir(@NotNull Module module) {
        PsiDirectory targetDirectory;
        String hostComponent;
        JSClass hostComponentClass;
        String defaultHostComponent;
        if (module == null) {
            CreateFlexSkinIntention.$$$reportNull$$$0(2);
        }
        String string = defaultHostComponent = (hostComponentClass = this.getHostComponentClass()) == null ? "" : hostComponentClass.getQualifiedName();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            hostComponent = defaultHostComponent;
            targetDirectory = (PsiDirectory)WriteAction.compute(() -> ActionScriptCreateClassOrInterfaceFix.findOrCreateDirectory((String)this.myPackageName, (PsiElement)this.myElement));
        } else {
            CreateFlexSkinDialog dialog = new CreateFlexSkinDialog(module, this.myClassName, this.myPackageName, defaultHostComponent, this.myElement.getContainingFile());
            if (!dialog.showAndGet()) {
                return Pair.empty();
            }
            hostComponent = dialog.getHostComponent();
            targetDirectory = dialog.getTargetDirectory();
        }
        return Pair.create((Object)CreateFlexSkinIntention.getSkinContent(hostComponent, this.myElement), (Object)targetDirectory);
    }

    private static String getSkinContent(String hostComponent, PsiElement context) {
        JSClass jsClass;
        Collection<String> skinStates;
        PsiElement element;
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        builder.append("<s:Skin xmlns:fx=\"http://ns.adobe.com/mxml/2009\" xmlns:s=\"library://ns.adobe.com/flex/spark\">\n");
        builder.append("\n");
        if (!StringUtil.isEmpty((String)hostComponent)) {
            builder.append("<fx:Metadata>\n");
            builder.append("[HostComponent(\"").append(hostComponent).append("\")]\n");
            builder.append("</fx:Metadata>\n");
            builder.append("\n");
        }
        if ((element = ActionScriptClassResolver.findClassByQNameStatic(hostComponent, context)) instanceof JSClass && !(skinStates = CreateFlexSkinIntention.getSkinStates(jsClass = (JSClass)element)).isEmpty()) {
            builder.append("<s:states>\n");
            for (String skinState : skinStates) {
                builder.append("<s:State name=\"").append(skinState).append("\"/>\n");
            }
            builder.append("</s:states>\n");
            builder.append("\n");
        }
        builder.append("</s:Skin>\n");
        return builder.toString();
    }

    private static Collection<String> getSkinStates(JSClass jsClass) {
        ArrayList<String> skinStates = new ArrayList<String>();
        CreateFlexSkinIntention.appendSkinStates(skinStates, jsClass, (Set<JSClass>)new THashSet());
        return skinStates;
    }

    private static void appendSkinStates(Collection<String> skinStates, JSClass jsClass, Set<JSClass> visited) {
        visited.add(jsClass);
        JSAttributeList attributeList = jsClass.getAttributeList();
        if (attributeList != null) {
            JSAttribute[] attributes;
            JSAttribute[] jSAttributeArray = attributes = attributeList.getAttributesByName("SkinState");
            int n = jSAttributeArray.length;
            for (int i = 0; i < n; ++i) {
                String state;
                JSAttribute attribute = jSAttributeArray[i];
                JSAttributeNameValuePair pair = attribute.getValueByName(null);
                if (pair == null || skinStates.contains(state = pair.getSimpleValue())) continue;
                skinStates.add(state);
            }
        }
        for (JSClass superClass : jsClass.getSuperClasses()) {
            if (visited.contains(superClass)) continue;
            CreateFlexSkinIntention.appendSkinStates(skinStates, superClass, visited);
        }
    }

    @Nullable
    private JSClass getHostComponentClass() {
        PsiElement declaration;
        XmlElementDescriptor descriptor;
        XmlTag tag = this.myElement instanceof XmlTag ? ((XmlTag)this.myElement).getParentTag() : (this.myElement instanceof XmlAttributeValue ? (XmlTag)this.myElement.getParent().getParent() : null);
        XmlElementDescriptor xmlElementDescriptor = descriptor = tag == null ? null : tag.getDescriptor();
        if (descriptor instanceof ClassBackedElementDescriptor && (declaration = descriptor.getDeclaration()) instanceof JSClass) {
            return (JSClass)declaration;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/actions/newfile/CreateFlexSkinIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/actions/newfile/CreateFlexSkinIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileTextAndDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

