/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flashbuilder;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableAirPackagingOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.PathUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilesToPackageUtil {
    private static final Logger LOG = Logger.getInstance((String)FilesToPackageUtil.class.getName());

    static void setupFilesToPackage(ModifiableAirPackagingOptions packagingOptions, Collection<String> pathsExcludedFromPackaging, ModuleRootModel rootModel) {
        ArrayList<AirPackagingOptions.FilePathAndPathInPackage> filesToPackage = new ArrayList<AirPackagingOptions.FilePathAndPathInPackage>();
        for (VirtualFile srcRoot : rootModel.getSourceRoots()) {
            FolderNode rootNode = new FolderNode(null, srcRoot.getPath(), ".");
            FilesToPackageUtil.initNodes(srcRoot, rootNode, pathsExcludedFromPackaging);
            FilesToPackageUtil.appendFilesToPackage(filesToPackage, rootNode);
        }
        packagingOptions.setFilesToPackage(filesToPackage);
    }

    private static void initNodes(final VirtualFile rootFolder, FolderNode rootFolderNode, Collection<String> pathsExcludedFromPackaging) {
        THashMap map = new THashMap();
        map.put(rootFolder, rootFolderNode);
        VfsUtilCore.visitChildrenRecursively((VirtualFile)rootFolder, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0], (Map)map, pathsExcludedFromPackaging){
            final /* synthetic */ Map val$map;
            final /* synthetic */ Collection val$pathsExcludedFromPackaging;
            {
                this.val$map = map;
                this.val$pathsExcludedFromPackaging = collection;
                super(arg0);
            }

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file.equals(rootFolder)) {
                    VirtualFileVisitor.Result result = CONTINUE;
                    if (result == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result;
                }
                VirtualFile parentFile = file.getParent();
                Node parentNode = (Node)this.val$map.get(parentFile);
                LOG.assertTrue(parentNode instanceof FolderNode, (Object)file.getPath());
                if (this.val$pathsExcludedFromPackaging.contains(((FolderNode)parentNode).getChildRelativePath(file.getName())) || file.getPath().endsWith("-app.xml") || !FilesToPackageUtil.canBeAddedToPackage(file)) {
                    ((FolderNode)parentNode).setHasExcludedChildren();
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return result;
                }
                if (file.isDirectory()) {
                    FolderNode childFolderNode = ((FolderNode)parentNode).addChildFolderNode(file.getPath());
                    this.val$map.put(file, childFolderNode);
                } else {
                    ((FolderNode)parentNode).addChildFileNode(file.getPath());
                }
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    1.$$$reportNull$$$0(3);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/flex/flashbuilder/FilesToPackageUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/flex/flashbuilder/FilesToPackageUtil$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static void appendFilesToPackage(List<AirPackagingOptions.FilePathAndPathInPackage> filesToPackage, FolderNode node) {
        if (node.hasExcludedChildren()) {
            for (Node childNode : node.getChildNodes()) {
                if (childNode instanceof FolderNode) {
                    FilesToPackageUtil.appendFilesToPackage(filesToPackage, (FolderNode)childNode);
                    continue;
                }
                filesToPackage.add(new AirPackagingOptions.FilePathAndPathInPackage(childNode.path, childNode.relativePath));
            }
        } else {
            filesToPackage.add(new AirPackagingOptions.FilePathAndPathInPackage(node.path, node.relativePath));
        }
    }

    private static boolean canBeAddedToPackage(VirtualFile file) {
        if (FileTypeManager.getInstance().isFileIgnored(file.getName())) {
            return false;
        }
        return file.isDirectory() || !FlexCommonUtils.isSourceFile((String)file.getName()) && !FileUtilRt.getExtension((String)file.getName()).equalsIgnoreCase("properties");
    }

    private static class FolderNode
    extends Node {
        private final Collection<Node> childNodes = new ArrayList<Node>();
        private boolean hasExcludedChildren;

        protected FolderNode(@Nullable FolderNode parent, String path, String relativePath) {
            super(parent, path, relativePath);
        }

        String getChildRelativePath(String childName) {
            return this.relativePath.equals(".") ? childName : this.relativePath + "/" + childName;
        }

        void setHasExcludedChildren() {
            if (this.hasExcludedChildren) {
                return;
            }
            FolderNode currentNode = this;
            do {
                currentNode.hasExcludedChildren = true;
            } while ((currentNode = currentNode.parentNode) != null);
        }

        private boolean hasExcludedChildren() {
            return this.hasExcludedChildren;
        }

        FolderNode addChildFolderNode(String childFolderPath) {
            int lastSlashIndex = childFolderPath.lastIndexOf("/");
            LOG.assertTrue(lastSlashIndex > 0 && this.path.equals(childFolderPath.substring(0, lastSlashIndex)), (Object)(this.path + ", " + childFolderPath));
            FolderNode childFolderNode = new FolderNode(this, childFolderPath, this.getChildRelativePath(PathUtil.getFileName((String)childFolderPath)));
            this.childNodes.add(childFolderNode);
            return childFolderNode;
        }

        Node addChildFileNode(String childFilePath) {
            int lastSlashIndex = childFilePath.lastIndexOf("/");
            LOG.assertTrue(lastSlashIndex > 0 && this.path.equals(childFilePath.substring(0, lastSlashIndex)), (Object)(this.path + ", " + childFilePath));
            Node childFileNode = new Node(this, childFilePath, this.getChildRelativePath(PathUtil.getFileName((String)childFilePath)));
            this.childNodes.add(childFileNode);
            return childFileNode;
        }

        Collection<Node> getChildNodes() {
            return this.childNodes;
        }
    }

    private static class Node {
        @Nullable
        final FolderNode parentNode;
        final String path;
        final String relativePath;

        protected Node(@Nullable FolderNode parentNode, String path, String relativePath) {
            this.parentNode = parentNode;
            this.path = path;
            this.relativePath = relativePath;
        }
    }
}

