/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flashbuilder;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderImporter;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderOpenProcessor;
import com.intellij.lang.javascript.flex.flashbuilder.SelectDirWithFlashBuilderProjectsStep;
import com.intellij.lang.javascript.flex.flashbuilder.SelectFlashBuilderImportedProjectsStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportProvider;
import org.jetbrains.annotations.Nullable;

public class FlashBuilderImportProvider
extends ProjectImportProvider {
    private final FlashBuilderOpenProcessor myProcessor;

    public FlashBuilderImportProvider(FlashBuilderImporter builder) {
        super((ProjectImportBuilder)builder);
        this.myProcessor = new FlashBuilderOpenProcessor(builder);
    }

    public ModuleWizardStep[] createSteps(WizardContext context) {
        return new ModuleWizardStep[]{new SelectDirWithFlashBuilderProjectsStep(context), new SelectFlashBuilderImportedProjectsStep(context)};
    }

    protected boolean canImportFromFile(VirtualFile file) {
        return this.myProcessor.canOpenProject(file);
    }

    public String getPathToBeImported(VirtualFile file) {
        return file.getPath();
    }

    @Nullable
    public String getFileSample() {
        return "<b>Flash Builder</b> project file (" + StringUtil.join((String[])this.myProcessor.getSupportedExtensions(), (String)", ") + ")";
    }
}

