/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flashbuilder;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderModuleImporter;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderProject;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderProjectFinder;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderProjectLoadUtil;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderSdkFinder;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.PathUtil;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import icons.FlexIcons;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FlashBuilderImporter
extends ProjectImportBuilder<String> {
    public static final String DOT_PROJECT = ".project";
    public static final String DOT_FXP = ".fxp";
    public static final String DOT_FXPL = ".fxpl";
    public static final String DOT_ZIP = ".zip";
    public static final String DOT_ACTION_SCRIPT_PROPERTIES = ".actionScriptProperties";
    public static final String DOT_FXP_PROPERTIES = ".fxpProperties";
    public static final String DOT_FLEX_PROPERTIES = ".flexProperties";
    public static final String DOT_FLEX_LIB_PROPERTIES = ".flexLibProperties";
    private Parameters myParameters;

    public Parameters getParameters() {
        if (this.myParameters == null) {
            this.myParameters = new Parameters();
        }
        return this.myParameters;
    }

    public void cleanup() {
        super.cleanup();
        this.myParameters = null;
    }

    @NotNull
    public String getName() {
        String string = FlexBundle.message("flash.builder", new Object[0]);
        if (string == null) {
            FlashBuilderImporter.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return FlexIcons.Flex.Flash_builder;
    }

    public boolean isMarked(String element) {
        return true;
    }

    public boolean isOpenProjectSettingsAfter() {
        return this.getParameters().myOpenProjectSettingsAfter;
    }

    public void setOpenProjectSettingsAfter(boolean openProjectSettingsAfter) {
        this.getParameters().myOpenProjectSettingsAfter = openProjectSettingsAfter;
    }

    public boolean isExtractToSubfolder() {
        return this.getParameters().myExtractToSubfolder;
    }

    public void setExtractToSubfolder(boolean extractToSubfolder) {
        this.getParameters().myExtractToSubfolder = extractToSubfolder;
    }

    public String getExtractPath() {
        return this.getParameters().myExtractPath;
    }

    public void setExtractPath(String extractPath) {
        this.getParameters().myExtractPath = extractPath;
    }

    public List<String> getList() {
        return this.getParameters().myFlashBuilderProjectFilePaths;
    }

    public void setList(List<String> flashBuilderProjectFiles) {
        this.getParameters().myFlashBuilderProjectFilePaths = flashBuilderProjectFiles;
    }

    void setInitiallySelectedPath(String dirPath) {
        this.getParameters().myInitiallySelectedPath = dirPath;
    }

    String getInitiallySelectedPath() {
        return this.getParameters().myInitiallySelectedPath;
    }

    public String getSuggestedProjectName() {
        VirtualFile file;
        String path = this.getInitiallySelectedPath();
        VirtualFile virtualFile = file = path.isEmpty() ? null : LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null) {
            return PathUtil.getFileName((String)path);
        }
        if (file.isDirectory()) {
            VirtualFile dotProjectFile = file.findChild(DOT_PROJECT);
            if (dotProjectFile != null && FlashBuilderProjectFinder.isFlashBuilderProject(dotProjectFile)) {
                return FlashBuilderProjectLoadUtil.readProjectName(dotProjectFile.getPath());
            }
        } else if (FlashBuilderProjectFinder.hasArchiveExtension(path)) {
            return file.getNameWithoutExtension();
        }
        if (DOT_PROJECT.equalsIgnoreCase(file.getName())) {
            return FlashBuilderProjectLoadUtil.readProjectName(file.getPath());
        }
        return PathUtil.getFileName((String)path);
    }

    public List<Module> commit(Project project, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        boolean needToCommit = model == null;
        ModifiableModuleModel moduleModel = model != null ? model : ModuleManager.getInstance((Project)project).getModifiableModel();
        List<String> paths = this.getList();
        boolean isArchive = paths.size() == 1 && FlashBuilderProjectFinder.hasArchiveExtension(paths.get(0));
        List<String> dotProjectPaths = this.getDotProjectPaths(project);
        List<FlashBuilderProject> flashBuilderProjects = FlashBuilderProjectLoadUtil.loadProjects(dotProjectPaths, isArchive);
        THashMap flashBuilderProjectToModifiableModelMap = new THashMap();
        THashMap moduleToModifiableModelMap = new THashMap();
        THashSet moduleNames = new THashSet(flashBuilderProjects.size());
        FlexProjectConfigurationEditor currentFlexEditor = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getConfigEditor();
        assert (needToCommit == (currentFlexEditor == null));
        for (FlashBuilderProject flashBuilderProject : flashBuilderProjects) {
            String moduleName = FlashBuilderImporter.makeUnique(flashBuilderProject.getName(), (Set<String>)moduleNames);
            moduleNames.add(moduleName);
            String moduleFilePath = flashBuilderProject.getProjectRootPath() + "/" + moduleName + ".iml";
            if (LocalFileSystem.getInstance().findFileByPath(moduleFilePath) != null) {
                ApplicationManager.getApplication().runWriteAction(() -> ModuleBuilder.deleteModuleFile((String)moduleFilePath));
            }
            Module module = moduleModel.newModule(moduleFilePath, FlexModuleType.getInstance().getId());
            ModifiableRootModel rootModel = currentFlexEditor != null ? currentFlexEditor.getModifiableRootModel(module) : ModuleRootManager.getInstance((Module)module).getModifiableModel();
            flashBuilderProjectToModifiableModelMap.put(flashBuilderProject, rootModel);
            moduleToModifiableModelMap.put(module, rootModel);
        }
        FlexProjectConfigurationEditor flexConfigEditor = currentFlexEditor != null ? currentFlexEditor : FlexProjectConfigurationEditor.createEditor(project, (Map<Module, ModifiableRootModel>)moduleToModifiableModelMap, null, null);
        FlashBuilderSdkFinder sdkFinder = new FlashBuilderSdkFinder(project, this.getParameters().myInitiallySelectedPath, flashBuilderProjects);
        FlashBuilderModuleImporter flashBuilderModuleImporter = new FlashBuilderModuleImporter(project, flexConfigEditor, flashBuilderProjects, sdkFinder);
        for (FlashBuilderProject flashBuilderProject : flashBuilderProjects) {
            flashBuilderModuleImporter.setupModule((ModifiableRootModel)flashBuilderProjectToModifiableModelMap.get(flashBuilderProject), flashBuilderProject);
        }
        if (needToCommit) {
            try {
                flexConfigEditor.commit();
            }
            catch (ConfigurationException e) {
                Logger.getInstance(FlashBuilderImporter.class).error((Throwable)e);
            }
            ApplicationManager.getApplication().runWriteAction(() -> FlashBuilderImporter.lambda$commit$1((Map)moduleToModifiableModelMap, moduleModel));
        }
        return new ArrayList<Module>(moduleToModifiableModelMap.keySet());
    }

    private List<String> getDotProjectPaths(Project project) {
        boolean creatingNewProject = !this.isUpdate();
        List<String> paths = this.getList();
        if (paths.size() == 1 && FlashBuilderProjectFinder.hasArchiveExtension(paths.get(0))) {
            String basePath;
            ArrayList<String> dotProjectFiles = new ArrayList<String>();
            boolean multipleProjects = FlashBuilderProjectFinder.isMultiProjectArchive(paths.get(0));
            String string = basePath = creatingNewProject ? project.getBaseDir().getPath() : this.getExtractPath();
            assert (basePath != null);
            String extractDir = multipleProjects || this.isExtractToSubfolder() ? basePath + "/" + FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)paths.get(0))) : basePath;
            try {
                File outputDir = new File(extractDir);
                ZipUtil.extract((File)new File(paths.get(0)), (File)outputDir, null);
                dotProjectFiles.add(extractDir + "/" + DOT_PROJECT);
                FlashBuilderImporter.extractNestedFxpAndAppendProjects(outputDir, dotProjectFiles);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    for (String dotProjectFile : dotProjectFiles) {
                        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathUtil.getParentPath((String)dotProjectFile));
                        if (file == null) continue;
                        file.refresh(false, true);
                    }
                });
            }
            catch (IOException e) {
                Messages.showErrorDialog((Project)project, (String)FlexBundle.message("failed.to.extract.project", e.getMessage()), (String)FlexBundle.message("open.project.0", PathUtil.getFileName((String)paths.get(0))));
                return Collections.emptyList();
            }
            return dotProjectFiles;
        }
        return paths;
    }

    private static void extractNestedFxpAndAppendProjects(File dir, List<String> dotProjectFiles) throws IOException {
        FilenameFilter filter = (dir1, name) -> {
            String lowercased = name.toLowerCase();
            return lowercased.endsWith(DOT_FXP) || lowercased.endsWith(DOT_FXPL);
        };
        for (File file : dir.listFiles(filter)) {
            File extractDir = new File(file.getParentFile().getParentFile(), FileUtil.getNameWithoutExtension((String)file.getName()));
            ZipUtil.extract((File)file, (File)extractDir, null);
            dotProjectFiles.add(extractDir + "/" + DOT_PROJECT);
            FlashBuilderImporter.extractNestedFxpAndAppendProjects(extractDir, dotProjectFiles);
        }
    }

    private static String makeUnique(String name, Set<String> moduleNames) {
        String uniqueName = name;
        int i = 1;
        while (moduleNames.contains(uniqueName)) {
            uniqueName = name + '(' + i++ + ')';
        }
        return uniqueName;
    }

    private static /* synthetic */ void lambda$commit$1(Map moduleToModifiableModelMap, ModifiableModuleModel moduleModel) {
        ModifiableModelCommitter.multiCommit(moduleToModifiableModelMap.values(), (ModifiableModuleModel)moduleModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flashbuilder/FlashBuilderImporter", "getName"));
    }

    public static class Parameters {
        private String myInitiallySelectedPath = "";
        private List<String> myFlashBuilderProjectFilePaths = Collections.emptyList();
        private String myExtractPath = "";
        private boolean myExtractToSubfolder = false;
        private boolean myOpenProjectSettingsAfter = false;
    }
}

