/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.library;

import com.intellij.ide.util.projectWizard.importSources.util.CommonSourceRootDetectionUtil;
import com.intellij.lang.javascript.ActionScriptFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.projectStructure.detection.FlexProjectStructureDetector;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.DistinctRootsCollection;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class FlexSourcesRootDetector
extends RootDetector {
    private final boolean myDetectMxml;

    public FlexSourcesRootDetector() {
        super(OrderRootType.SOURCES, false, FlexBundle.message("sources.root.detector.name", new Object[0]));
        this.myDetectMxml = true;
    }

    @NotNull
    public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
        if (rootCandidate == null) {
            FlexSourcesRootDetector.$$$reportNull$$$0(0);
        }
        if (progressIndicator == null) {
            FlexSourcesRootDetector.$$$reportNull$$$0(1);
        }
        DistinctRootsCollection<VirtualFile> result = new DistinctRootsCollection<VirtualFile>(){

            protected boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile virtualFile) {
                if (ancestor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (virtualFile == null) {
                    1.$$$reportNull$$$0(1);
                }
                return VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)virtualFile, (boolean)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ancestor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "virtualFile";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/flex/library/FlexSourcesRootDetector$1";
                objectArray[2] = "isAncestor";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.collectRoots(rootCandidate, (Collection<VirtualFile>)result, rootCandidate, progressIndicator);
        DistinctRootsCollection<VirtualFile> distinctRootsCollection = result;
        if (distinctRootsCollection == null) {
            FlexSourcesRootDetector.$$$reportNull$$$0(2);
        }
        return distinctRootsCollection;
    }

    private void collectRoots(final VirtualFile startFile, final Collection<VirtualFile> result, final VirtualFile topmostRoot, final ProgressIndicator progressIndicator) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)startFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                progressIndicator.checkCanceled();
                progressIndicator.setText2(file.getPresentableUrl());
                if (!file.isDirectory()) {
                    if (file.getFileType() == ActionScriptFileType.INSTANCE) {
                        Pair root = CommonSourceRootDetectionUtil.VIRTUAL_FILE.suggestRootForFileWithPackageStatement((Object)file, (Object)topmostRoot, FlexProjectStructureDetector.PACKAGE_NAME_FETCHER, false);
                        if (root != null) {
                            VirtualFile detectedRoot = (VirtualFile)root.first;
                            result.add(detectedRoot);
                            if (VfsUtilCore.isAncestor((VirtualFile)detectedRoot, (VirtualFile)startFile, (boolean)false)) {
                                VirtualFileVisitor.Result result2 = 2.skipTo((VirtualFile)detectedRoot);
                                if (result2 == null) {
                                    2.$$$reportNull$$$0(1);
                                }
                                return result2;
                            }
                        }
                    } else if (FlexSourcesRootDetector.this.myDetectMxml && JavaScriptSupportLoader.isFlexMxmFile((String)file.getName())) {
                        result.add(file.getParent());
                    }
                }
                VirtualFileVisitor.Result result3 = CONTINUE;
                if (result3 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return result3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/flex/library/FlexSourcesRootDetector$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/flex/library/FlexSourcesRootDetector$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCandidate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/library/FlexSourcesRootDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/library/FlexSourcesRootDetector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectRoots";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

