/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.lang.javascript.flex.projectStructure.model.SdkEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.DependencyTypeImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class SdkEntryImpl
implements SdkEntry {
    @NotNull
    private final String myName;
    private final LinkedHashMap<String, DependencyTypeImpl> myDependencyTypes;

    public SdkEntryImpl(State state) {
        this.myDependencyTypes = new LinkedHashMap();
        this.myName = StringUtil.notNullize((String)state.NAME);
        for (EntryState entryState : state.DEPENDENCY_TYPES) {
            DependencyTypeImpl dependencyType = new DependencyTypeImpl();
            dependencyType.loadState(entryState.TYPE);
            this.myDependencyTypes.put((Object)entryState.URL, (Object)dependencyType);
        }
    }

    public SdkEntryImpl(@NotNull String name) {
        if (name == null) {
            SdkEntryImpl.$$$reportNull$$$0(0);
        }
        this.myDependencyTypes = new LinkedHashMap();
        this.myName = name;
    }

    public SdkEntryImpl getCopy() {
        SdkEntryImpl copy = new SdkEntryImpl(this.myName);
        this.applyTo(copy);
        return copy;
    }

    private void applyTo(SdkEntryImpl copy) {
        copy.myDependencyTypes.clear();
        copy.myDependencyTypes.putAll(this.myDependencyTypes);
    }

    public boolean isEqual(@NotNull SdkEntryImpl that) {
        if (that == null) {
            SdkEntryImpl.$$$reportNull$$$0(1);
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        Iterator i1 = this.myDependencyTypes.keySet().iterator();
        Iterator i2 = that.myDependencyTypes.keySet().iterator();
        while (i1.hasNext() && i2.hasNext()) {
            String url2;
            String url1 = (String)i1.next();
            if (!url1.equals(url2 = (String)i2.next())) {
                return true;
            }
            if (Comparing.equal((Object)this.myDependencyTypes.get((Object)url1), (Object)this.myDependencyTypes.get((Object)url2))) continue;
            return true;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            SdkEntryImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public State getState() {
        State state = new State();
        state.NAME = this.myName;
        for (Map.Entry entry : this.myDependencyTypes.entrySet()) {
            EntryState entryState = new EntryState();
            entryState.URL = (String)entry.getKey();
            entryState.TYPE = ((DependencyTypeImpl)entry.getValue()).getState();
            state.DEPENDENCY_TYPES.add(entryState);
        }
        return state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/projectStructure/model/impl/SdkEntryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/projectStructure/model/impl/SdkEntryImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEqual";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="entry")
    public static class EntryState {
        @Attribute(value="url")
        public String URL;
        @Property(surroundWithTag=false)
        public DependencyTypeImpl.State TYPE;
    }

    @Tag(value="sdk")
    public static class State {
        @Attribute(value="name")
        public String NAME;
        @Tag(value="dependencies")
        public List<EntryState> DEPENDENCY_TYPES = new ArrayList<EntryState>();
    }
}

