/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.ui.CompositeConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.DependenciesConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.FlexBCConfigurable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.ui.navigation.Place;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FlexProjectStructureUtil {
    public static Place createPlace(FlexBCConfigurable configurable, @Nullable String tabName) {
        Place place = new Place().putPath("category", (Object)ModuleStructureConfigurable.getInstance((Project)configurable.getModule().getProject())).putPath("treeObject", (Object)configurable.getEditableObject());
        if (tabName != null) {
            place.putPath("tabName", (Object)tabName);
        }
        return place;
    }

    public static Place createPlace(Module module, DependenciesConfigurable configurable) {
        FlexBCConfigurable bcConfigurable = FlexProjectStructureUtil.findBcConfigurable(module, configurable);
        return FlexProjectStructureUtil.createPlace(bcConfigurable, DependenciesConfigurable.TAB_NAME);
    }

    public static Place createPlace(Module module, FlexBuildConfiguration bc, @Nullable String tabName) {
        FlexBCConfigurable bcConfigurable = FlexProjectStructureUtil.findBcConfigurable(module, bc);
        return FlexProjectStructureUtil.createPlace(bcConfigurable, tabName);
    }

    @Nullable
    private static FlexBCConfigurable findBcConfigurable(Module module, DependenciesConfigurable configurable) {
        List<CompositeConfigurable> configurables = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getBCConfigurables(module);
        for (CompositeConfigurable compositeConfigurable : configurables) {
            FlexBCConfigurable bcConfigurable = FlexBCConfigurable.unwrap(compositeConfigurable);
            if (bcConfigurable.getEditableObject().getDependencies() != configurable.getEditableObject()) continue;
            return bcConfigurable;
        }
        return null;
    }

    @Nullable
    private static FlexBCConfigurable findBcConfigurable(Module module, FlexBuildConfiguration bc) {
        List<CompositeConfigurable> configurables = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getBCConfigurables(module);
        for (CompositeConfigurable compositeConfigurable : configurables) {
            FlexBCConfigurable bcConfigurable = FlexBCConfigurable.unwrap(compositeConfigurable);
            if (bcConfigurable.getEditableObject() != bc) continue;
            return bcConfigurable;
        }
        return null;
    }
}

