/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.WebBrowserReferenceConverter;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherParameters
implements Cloneable {
    @NotNull
    private LauncherType myLauncherType;
    @NotNull
    private String myPlayerPath;
    private boolean myNewPlayerInstance;
    @NotNull
    private WebBrowser myBrowser;

    public LauncherParameters() {
        this.myLauncherType = LauncherType.OSDefault;
        this.myPlayerPath = SystemInfo.isMac ? "/Applications/Flash Player Debugger.app" : (SystemInfo.isWindows ? "FlashPlayerDebugger.exe" : "/usr/bin/flashplayerdebugger");
        this.myNewPlayerInstance = false;
        this.myBrowser = WebBrowserManager.getInstance().getFirstBrowser(BrowserFamily.FIREFOX);
    }

    public LauncherParameters(@NotNull LauncherType launcherType, @NotNull WebBrowser browser, @NotNull String playerPath, boolean isNewPlayerInstance) {
        if (launcherType == null) {
            LauncherParameters.$$$reportNull$$$0(0);
        }
        if (browser == null) {
            LauncherParameters.$$$reportNull$$$0(1);
        }
        if (playerPath == null) {
            LauncherParameters.$$$reportNull$$$0(2);
        }
        this.myLauncherType = LauncherType.OSDefault;
        this.myPlayerPath = SystemInfo.isMac ? "/Applications/Flash Player Debugger.app" : (SystemInfo.isWindows ? "FlashPlayerDebugger.exe" : "/usr/bin/flashplayerdebugger");
        this.myNewPlayerInstance = false;
        this.myBrowser = WebBrowserManager.getInstance().getFirstBrowser(BrowserFamily.FIREFOX);
        this.myLauncherType = launcherType;
        this.myBrowser = browser;
        this.myPlayerPath = playerPath;
        this.myNewPlayerInstance = isNewPlayerInstance;
    }

    public String getPresentableText() {
        switch (this.myLauncherType) {
            case OSDefault: {
                return FlexBundle.message("system.default.application", new Object[0]);
            }
            case Browser: {
                return this.myBrowser.getName();
            }
            case Player: {
                return FileUtil.toSystemDependentName((String)this.myPlayerPath);
            }
        }
        assert (false);
        return "";
    }

    @NotNull
    public LauncherType getLauncherType() {
        LauncherType launcherType = this.myLauncherType;
        if (launcherType == null) {
            LauncherParameters.$$$reportNull$$$0(3);
        }
        return launcherType;
    }

    public void setLauncherType(@NotNull LauncherType launcherType) {
        if (launcherType == null) {
            LauncherParameters.$$$reportNull$$$0(4);
        }
        this.myLauncherType = launcherType;
    }

    @OptionTag(converter=WebBrowserReferenceConverter.class)
    @NotNull
    public WebBrowser getBrowser() {
        WebBrowser webBrowser = this.myBrowser;
        if (webBrowser == null) {
            LauncherParameters.$$$reportNull$$$0(5);
        }
        return webBrowser;
    }

    public void setBrowser(@Nullable WebBrowser browser) {
        this.myBrowser = browser == null ? WebBrowserManager.getInstance().getFirstBrowser(BrowserFamily.FIREFOX) : browser;
    }

    @NotNull
    public String getPlayerPath() {
        String string = this.myPlayerPath;
        if (string == null) {
            LauncherParameters.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setPlayerPath(@NotNull String playerPath) {
        if (playerPath == null) {
            LauncherParameters.$$$reportNull$$$0(7);
        }
        this.myPlayerPath = FileUtil.toSystemIndependentName((String)playerPath);
    }

    public boolean isNewPlayerInstance() {
        return this.myNewPlayerInstance;
    }

    public void setNewPlayerInstance(boolean newPlayerInstance) {
        this.myNewPlayerInstance = newPlayerInstance;
    }

    public LauncherParameters clone() {
        try {
            return (LauncherParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LauncherParameters that = (LauncherParameters)o;
        if (this.myBrowser != that.myBrowser) {
            return false;
        }
        if (this.myLauncherType != that.myLauncherType) {
            return false;
        }
        return this.myPlayerPath.equals(that.myPlayerPath);
    }

    public int hashCode() {
        assert (false);
        return super.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "playerPath";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/run/LauncherParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/run/LauncherParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlayerPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setLauncherType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPlayerPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum LauncherType {
        OSDefault,
        Browser,
        Player;

    }
}

