/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.lang.javascript.flex.run.BCCombo;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.lang.javascript.flex.run.RemoteFlashRunConfiguration;
import com.intellij.lang.javascript.flex.run.RemoteFlashRunnerParameters;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class RemoteFlashRunConfigurationForm
extends SettingsEditor<RemoteFlashRunConfiguration> {
    private JPanel myMainPanel;
    private BCCombo myBCCombo;
    private JRadioButton myOnComputerRadioButton;
    private JRadioButton myOnAndroidDeviceRadioButton;
    private JRadioButton myOnIOSDeviceRadioButton;
    private JPanel myDeviceOptionsPanel;
    private JRadioButton myDebugOverNetworkRadioButton;
    private JRadioButton myDebugOverUSBRadioButton;
    private JTextField myUsbDebugPortTextField;
    private final Project myProject;

    public RemoteFlashRunConfigurationForm(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteFlashRunConfigurationForm.this.updateControls();
            }
        };
        this.myOnComputerRadioButton.addActionListener(listener);
        this.myOnAndroidDeviceRadioButton.addActionListener(listener);
        this.myOnIOSDeviceRadioButton.addActionListener(listener);
        this.myDebugOverNetworkRadioButton.addActionListener(listener);
        this.myDebugOverUSBRadioButton.addActionListener(listener);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            RemoteFlashRunConfigurationForm.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    protected void resetEditorFrom(@NotNull RemoteFlashRunConfiguration configuration) {
        if (configuration == null) {
            RemoteFlashRunConfigurationForm.$$$reportNull$$$0(1);
        }
        RemoteFlashRunnerParameters params = configuration.getRunnerParameters();
        this.myBCCombo.resetFrom(params);
        this.myOnComputerRadioButton.setSelected(params.getRemoteDebugTarget() == RemoteFlashRunnerParameters.RemoteDebugTarget.Computer);
        this.myOnAndroidDeviceRadioButton.setSelected(params.getRemoteDebugTarget() == RemoteFlashRunnerParameters.RemoteDebugTarget.AndroidDevice);
        this.myOnIOSDeviceRadioButton.setSelected(params.getRemoteDebugTarget() == RemoteFlashRunnerParameters.RemoteDebugTarget.iOSDevice);
        this.myDebugOverNetworkRadioButton.setSelected(params.getDebugTransport() == FlashRunnerParameters.AirMobileDebugTransport.Network);
        this.myDebugOverUSBRadioButton.setSelected(params.getDebugTransport() == FlashRunnerParameters.AirMobileDebugTransport.USB);
        this.myUsbDebugPortTextField.setText(String.valueOf(params.getUsbDebugPort()));
        this.updateControls();
    }

    protected void applyEditorTo(@NotNull RemoteFlashRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            RemoteFlashRunConfigurationForm.$$$reportNull$$$0(2);
        }
        RemoteFlashRunnerParameters params = configuration.getRunnerParameters();
        this.myBCCombo.applyTo(params);
        RemoteFlashRunnerParameters.RemoteDebugTarget remoteDebugTarget = this.myOnComputerRadioButton.isSelected() ? RemoteFlashRunnerParameters.RemoteDebugTarget.Computer : (this.myOnAndroidDeviceRadioButton.isSelected() ? RemoteFlashRunnerParameters.RemoteDebugTarget.AndroidDevice : RemoteFlashRunnerParameters.RemoteDebugTarget.iOSDevice);
        params.setRemoteDebugTarget(remoteDebugTarget);
        params.setDebugTransport(this.myDebugOverNetworkRadioButton.isSelected() ? FlashRunnerParameters.AirMobileDebugTransport.Network : FlashRunnerParameters.AirMobileDebugTransport.USB);
        try {
            int port = Integer.parseInt(this.myUsbDebugPortTextField.getText().trim());
            if (port > 0 && port < 65535) {
                params.setUsbDebugPort(port);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void disposeEditor() {
        this.myBCCombo.dispose();
    }

    private void updateControls() {
        UIUtil.setEnabled((Component)this.myDeviceOptionsPanel, (this.myOnAndroidDeviceRadioButton.isSelected() || this.myOnIOSDeviceRadioButton.isSelected() ? 1 : 0) != 0, (boolean)true);
        this.myUsbDebugPortTextField.setEnabled(this.myDebugOverUSBRadioButton.isEnabled() && this.myDebugOverUSBRadioButton.isSelected());
    }

    private void createUIComponents() {
        this.myBCCombo = new BCCombo(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/run/RemoteFlashRunConfigurationForm";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/run/RemoteFlashRunConfigurationForm";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JTextField jTextField;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Build configuration:");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(6);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("Debugger is taken from the Flex/AIR SDK configured for the selected build configuration.");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null, 2));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel2.setText("Source files are searched according to the dependencies of the selected build configuration.");
        jPanel2.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null, 2));
        BCCombo bCCombo = this.myBCCombo;
        jPanel2.add((Component)bCCombo, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Debugged app runs on:", (int)0, (int)0, null, null));
        this.myOnAndroidDeviceRadioButton = jRadioButton5 = new JRadioButton();
        ((Component)jRadioButton5).setEnabled(true);
        jRadioButton5.setText("Android device");
        jRadioButton5.setMnemonic('V');
        jRadioButton5.setDisplayedMnemonicIndex(10);
        jPanel3.add((Component)jRadioButton5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOnComputerRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("This or remote computer");
        jRadioButton4.setMnemonic('T');
        jRadioButton4.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDeviceOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDebugOverNetworkRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Network");
        jRadioButton3.setMnemonic('W');
        jRadioButton3.setDisplayedMnemonicIndex(3);
        jPanel.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDebugOverUSBRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("USB, port:");
        jRadioButton2.setMnemonic('B');
        jRadioButton2.setDisplayedMnemonicIndex(2);
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUsbDebugPortTextField = jTextField = new JTextField();
        jTextField.setColumns(4);
        jPanel.add((Component)jTextField, new GridConstraints(0, 3, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Debug on device over: ");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOnIOSDeviceRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("iOS device");
        jRadioButton.setMnemonic('S');
        jRadioButton.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel.setLabelFor(bCCombo);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

