/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.actionscript.fixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSConstructorChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptConstructorChecker
extends JSConstructorChecker {
    public ActionScriptConstructorChecker(@NotNull JSAnnotatorProblemReporter problemReporter) {
        if (problemReporter == null) {
            ActionScriptConstructorChecker.$$$reportNull$$$0(0);
        }
        super(problemReporter);
    }

    public void checkMissedConstructor(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            ActionScriptConstructorChecker.$$$reportNull$$$0(1);
        }
        if (jsClass.isInterface()) {
            return;
        }
        JSFunction nontrivialSuperClassConstructor = ActionScriptConstructorChecker.getNontrivialSuperClassConstructor((JSClass)jsClass);
        if (nontrivialSuperClassConstructor == null) {
            return;
        }
        PsiElement place = JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)jsClass);
        Annotation annotation = this.myProblemReporter.registerGenericError(place, JSBundle.message((String)"javascript.validation.message.missed.super.constructor.call", (Object[])new Object[0]), new IntentionAction[0]);
        annotation.registerFix(JSFixFactory.getInstance().addConstructorAndSuperInvocationFix(jsClass, nontrivialSuperClassConstructor));
    }

    protected void checkInstanceMemberAccesses(@NotNull JSFunction constructor, @NotNull JSClass clazz) {
        if (constructor == null) {
            ActionScriptConstructorChecker.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            ActionScriptConstructorChecker.$$$reportNull$$$0(3);
        }
    }

    @Contract(value="null -> null")
    protected JSCallExpression findAnyBaseConstructorCall(@Nullable JSFunction jsFunction) {
        if (jsFunction == null) {
            return null;
        }
        JSSourceElement[] body = jsFunction.getBody();
        return body.length > 0 ? ActionScriptConstructorChecker.findBaseConstructorCall((JSBlockStatement)body[0]) : null;
    }

    private static JSCallExpression findBaseConstructorCall(JSBlockStatement blockStatement) {
        for (JSStatement statement : blockStatement.getStatements()) {
            JSStatement then;
            JSExpression expr;
            if (statement instanceof JSExpressionStatement && (expr = ((JSExpressionStatement)statement).getExpression()) instanceof JSCallExpression && ((JSCallExpression)expr).getMethodExpression() instanceof JSSuperExpression) {
                return (JSCallExpression)expr;
            }
            if (!(statement instanceof JSIfStatement) || !((then = ((JSIfStatement)statement).getThen()) instanceof JSBlockStatement)) continue;
            return ActionScriptConstructorChecker.findBaseConstructorCall((JSBlockStatement)then);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemReporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/actionscript/fixes/ActionScriptConstructorChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMissedConstructor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInstanceMemberAccesses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

