/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nashorn;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import jdk.internal.dynalink.beans.StaticClass;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

public final class NashornDebuggerSupport {
    private NashornDebuggerSupport() {
    }

    public static VariableDescriptor[] getProperties(Object object) {
        if (!(object instanceof ScriptObject)) {
            return VariableDescriptor.EMPTY_ARRAY;
        }
        ScriptObject host = (ScriptObject)object;
        ArrayList<VariableDescriptor> variables = new ArrayList<VariableDescriptor>();
        for (Property property : host.getMap().getProperties()) {
            if (!property.isEnumerable()) continue;
            variables.add(NashornDebuggerSupport.createValue(property.getKey(), 0, property.getObjectValue(host, host)));
        }
        return variables.toArray(new VariableDescriptor[variables.size()]);
    }

    private static VariableDescriptor createValue(String name, int arrayIndex, Object value) {
        ValueType type;
        String valueString = null;
        boolean passObjectValue = false;
        int length = 0;
        if (value == null) {
            type = ValueType.NULL;
        } else if (value instanceof ScriptObject) {
            passObjectValue = true;
            if (value instanceof ScriptFunction) {
                type = ValueType.FUNCTION;
                valueString = ((ScriptFunction)value).toSource();
            } else {
                ScriptObject scriptObject = (ScriptObject)value;
                if (scriptObject.isArray()) {
                    type = ValueType.ARRAY;
                    length = (int)scriptObject.getArray().length();
                } else {
                    type = ValueType.OBJECT;
                }
            }
        } else if (value instanceof Boolean) {
            type = ValueType.BOOLEAN;
            valueString = value.toString();
        } else if (value instanceof String || value instanceof ConsString) {
            type = ValueType.STRING;
            valueString = value.toString();
            length = valueString.length();
        } else if (value instanceof Number) {
            type = ValueType.NUMBER;
            valueString = JSType.toString((double)((Number)value).doubleValue());
        } else if (value == ScriptRuntime.UNDEFINED) {
            type = ValueType.UNDEFINED;
        } else {
            type = null;
            passObjectValue = true;
            if (value instanceof StaticClass) {
                value = ((StaticClass)value).getRepresentedClass();
            }
        }
        return new VariableDescriptor(name, arrayIndex, type, valueString, passObjectValue ? value : null, length);
    }

    public static VariableDescriptor[] getIndexedValues(Object object, int index, int length) {
        ScriptObject host = (ScriptObject)object;
        ArrayData array = host.getArray();
        ArrayList<VariableDescriptor> values = new ArrayList<VariableDescriptor>(Math.max(length, 1000));
        int n = Math.min((int)array.length(), index + length);
        for (int i = index; i < n; ++i) {
            if (!array.has(i)) continue;
            values.add(NashornDebuggerSupport.createValue(null, i, array.getObject(i)));
        }
        return values.toArray(new VariableDescriptor[values.size()]);
    }

    public static VariableDescriptor evaluate(Object string, Object scope, Object self) {
        try {
            Method evalMethod;
            Object[] args;
            Global global = Context.getGlobal();
            Global initialScope = scope == null ? global : (ScriptObject)scope;
            Object callThis = self == null ? global : self;
            Method contextMethod = global.getClass().getDeclaredMethod("getContext", new Class[0]);
            contextMethod.setAccessible(true);
            Context context = (Context)contextMethod.invoke((Object)global, new Object[0]);
            try {
                args = new Object[]{initialScope, string, callThis, ScriptRuntime.UNDEFINED};
                evalMethod = context.getClass().getDeclaredMethod("eval", ScriptObject.class, String.class, Object.class, Object.class);
            }
            catch (NoSuchMethodException e) {
                args = new Object[]{initialScope, string, callThis, ScriptRuntime.UNDEFINED, false};
                evalMethod = context.getClass().getDeclaredMethod("eval", ScriptObject.class, String.class, Object.class, Object.class, Boolean.TYPE);
            }
            evalMethod.setAccessible(true);
            try {
                return NashornDebuggerSupport.createValue(null, 0, evalMethod.invoke((Object)context, args));
            }
            catch (Throwable e) {
                return NashornDebuggerSupport.createValue("wasThrown", 0, e);
            }
        }
        catch (Throwable e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            e.printStackTrace(writer);
            return NashornDebuggerSupport.createValue("wasThrown", 0, stringWriter.getBuffer().toString());
        }
    }

    public static class VariableDescriptor {
        static final VariableDescriptor[] EMPTY_ARRAY = new VariableDescriptor[0];
        public final String name;
        public int index;
        public final int type;
        public final String stringValue;
        public final Object value;
        public final int length;

        private VariableDescriptor(String name, int index, ValueType type, String stringValue, Object value, int length) {
            this.name = name;
            this.type = type == null ? -1 : type.ordinal();
            this.stringValue = stringValue;
            this.value = value;
            this.length = length;
            this.index = index;
        }
    }

    private static enum ValueType {
        OBJECT,
        NUMBER,
        STRING,
        FUNCTION,
        BOOLEAN,
        ARRAY,
        NODE,
        UNDEFINED,
        NULL;

    }
}

