/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.constraints.GrailsConstraintsUtil;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;

public abstract class DomainFieldIntention
implements IntentionAction {
    private final String myLabel;
    private final Object myValue;

    protected DomainFieldIntention(String label, Object value) {
        this.myLabel = label;
        this.myValue = value;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            DomainFieldIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected abstract boolean isAppropriateField(@NotNull GrField var1, @NotNull PsiType var2);

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiType fieldType;
        PsiElement element;
        if (project == null) {
            DomainFieldIntention.$$$reportNull$$$0(1);
        }
        if (!PsiImplUtil.isLeafElementOfType((PsiElement)(element = file.findElementAt(editor.getCaretModel().getOffset())), (IElementType)GroovyTokenTypes.mIDENT)) {
            return false;
        }
        PsiElement eField = element.getParent();
        if (!(eField instanceof GrField)) {
            return false;
        }
        GrField field = (GrField)eField;
        PsiClass aClass = field.getContainingClass();
        if (!(aClass instanceof GrTypeDefinition)) {
            return false;
        }
        String name = field.getName();
        if (GormUtils.isGormBean(aClass)) {
            Pair<PsiType, PsiElement> pair = DomainDescriptor.getPersistentProperties(aClass).get(name);
            if (pair == null) {
                return false;
            }
            fieldType = (PsiType)pair.first;
        } else {
            if (!GrailsUtils.isValidatedClass(aClass)) {
                return false;
            }
            fieldType = field.getTypeGroovy();
        }
        if (fieldType != null && !this.isAppropriateField(field, fieldType)) {
            return false;
        }
        PsiField constraintsField = aClass.findFieldByName("constraints", false);
        if (!(constraintsField instanceof GrField)) {
            return true;
        }
        GrExpression initializerGroovy = ((GrField)constraintsField).getInitializerGroovy();
        if (initializerGroovy == null) {
            return true;
        }
        if (initializerGroovy instanceof GrLiteral) {
            return ((GrLiteral)initializerGroovy).getValue() == ObjectUtils.NULL;
        }
        if (!(initializerGroovy instanceof GrClosableBlock)) {
            return false;
        }
        for (PsiElement child = initializerGroovy.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiMethod method;
            GrMethodCall call;
            GrExpression invokedExpression;
            if (!(child instanceof GrMethodCall) || !((invokedExpression = (call = (GrMethodCall)child).getInvokedExpression()) instanceof GrReferenceExpression) || !name.equals(((GrReferenceExpression)invokedExpression).getReferenceName()) || !GrailsConstraintsUtil.isConstraintsMethod((PsiElement)(method = call.resolveMethod()))) continue;
            for (GrNamedArgument namedArgument : call.getNamedArguments()) {
                GrArgumentLabel label = namedArgument.getLabel();
                if (label == null || !this.myLabel.equals(label.getName())) continue;
                GrExpression expression = namedArgument.getExpression();
                if (expression == null) {
                    return true;
                }
                if (!(expression instanceof GrLiteral)) {
                    return false;
                }
                return !this.myValue.equals(((GrLiteral)expression).getValue());
            }
            return true;
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        GrExpression initializerGroovy;
        if (project == null) {
            DomainFieldIntention.$$$reportNull$$$0(2);
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        assert (element != null);
        GrField field = (GrField)element.getParent();
        GrTypeDefinition aClass = (GrTypeDefinition)field.getContainingClass();
        assert (aClass != null);
        String name = field.getName();
        assert (name != null);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        GrField constraintsField = (GrField)aClass.findFieldByName("constraints", false);
        if (constraintsField == null) {
            GrVariableDeclaration constraintDefinition = factory.createFieldDeclarationFromText("static constraints = {}");
            GrTypeDefinitionBody body = aClass.getBody();
            PsiElement lastChild = body.getLastChild();
            if (!PsiImplUtil.isLeafElementOfType((PsiElement)lastChild, (IElementType)GroovyTokenTypes.mRCURLY)) {
                return;
            }
            assert (lastChild != null);
            PsiElement prev = lastChild.getPrevSibling();
            int lineBreakCount = 0;
            if (prev instanceof LeafPsiElement && org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil.isWhiteSpaceOrNls((PsiElement)prev)) {
                CharSequence text = ((LeafPsiElement)prev).getChars();
                for (int i = 0; i < text.length(); ++i) {
                    if (text.charAt(i) != '\n') continue;
                    ++lineBreakCount;
                }
            }
            for (int i = lineBreakCount; i < 2; ++i) {
                body.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", lastChild.getNode());
            }
            constraintDefinition = (GrVariableDeclaration)body.addBefore((PsiElement)constraintDefinition, lastChild);
            constraintsField = (GrField)constraintDefinition.getVariables()[0];
        }
        if ((initializerGroovy = constraintsField.getInitializerGroovy()) == null || initializerGroovy instanceof GrLiteral) {
            GrVariableDeclaration constraintDefinition = factory.createFieldDeclarationFromText("\n  static constraints = {\n  }\n");
            GrField newConstraintField = (GrField)constraintDefinition.getVariables()[0];
            constraintsField = (GrField)constraintsField.replace((PsiElement)newConstraintField);
            initializerGroovy = constraintsField.getInitializerGroovy();
            assert (initializerGroovy != null);
        }
        GrNamedArgument newNamedArgument = factory.createNamedArgument(this.myLabel, (GrExpression)factory.createLiteralFromValue(this.myValue));
        for (PsiElement child = initializerGroovy.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiMethod method;
            GrMethodCall call;
            GrExpression invokedExpression;
            if (!(child instanceof GrMethodCall) || !((invokedExpression = (call = (GrMethodCall)child).getInvokedExpression()) instanceof GrReferenceExpression) || !name.equals(((GrReferenceExpression)invokedExpression).getReferenceName()) || !GrailsConstraintsUtil.isConstraintsMethod((PsiElement)(method = call.resolveMethod()))) continue;
            for (GrNamedArgument namedArgument : call.getNamedArguments()) {
                GrArgumentLabel label = namedArgument.getLabel();
                if (label == null || !this.myLabel.equals(label.getName())) continue;
                namedArgument.replace((PsiElement)newNamedArgument);
                return;
            }
            GrArgumentList argumentList = call.getArgumentList();
            argumentList.addNamedArgument(newNamedArgument);
            return;
        }
        GrStatement statement = factory.createStatementFromText((CharSequence)(name + '(' + newNamedArgument.getText() + ')'));
        ((GrClosableBlock)initializerGroovy).addStatementBefore(statement, null);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/actions/DomainFieldIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/actions/DomainFieldIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

