/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.actions.ArtefactData;
import org.jetbrains.plugins.grails.artefact.api.GrailsArtefactHandler;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.tests.GrailsTestUtils;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u000e\u001a\u0010\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u000e\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u000e\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0004\"\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0004\u00a8\u0006\u0013"}, d2={"GRAILS_APPLICATION", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/grails/structure/GrailsApplication;", "getGRAILS_APPLICATION", "()Lcom/intellij/openapi/actionSystem/DataKey;", "GRAILS_ARTEFACT_HANDLER", "Lorg/jetbrains/plugins/grails/artefact/api/GrailsArtefactHandler;", "getGRAILS_ARTEFACT_HANDLER", "GRAILS_ARTEFACT_PACKAGE", "", "getGRAILS_ARTEFACT_PACKAGE", "getArtefactData", "Lorg/jetbrains/plugins/grails/actions/ArtefactData;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "getArtefactHandler", "dataContext", "getArtefactPackage", "getGrailsApplication", "groovy-mvc"})
public final class GrailsActionUtilKt {
    @NotNull
    private static final DataKey<GrailsApplication> GRAILS_APPLICATION;
    @NotNull
    private static final DataKey<GrailsArtefactHandler> GRAILS_ARTEFACT_HANDLER;
    @NotNull
    private static final DataKey<String> GRAILS_ARTEFACT_PACKAGE;

    @NotNull
    public static final DataKey<GrailsApplication> getGRAILS_APPLICATION() {
        return GRAILS_APPLICATION;
    }

    @NotNull
    public static final DataKey<GrailsArtefactHandler> getGRAILS_ARTEFACT_HANDLER() {
        return GRAILS_ARTEFACT_HANDLER;
    }

    @NotNull
    public static final DataKey<String> getGRAILS_ARTEFACT_PACKAGE() {
        return GRAILS_ARTEFACT_PACKAGE;
    }

    @Nullable
    public static final ArtefactData getArtefactData(@Nullable DataContext context) {
        Object artefactName;
        String packageName;
        boolean isView;
        if (context == null) {
            return null;
        }
        Project project = (Project)context.getData(LangDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        if (DumbService.isDumb((Project)project2)) {
            return null;
        }
        Module module = (Module)context.getData(LangDataKeys.MODULE);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        VirtualFile virtualFile = (VirtualFile)context.getData(LangDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        GrailsApplication grailsApplication2 = GrailsApplicationManager.getInstance(project2).findApplication(file);
        if (grailsApplication2 == null) {
            return null;
        }
        GrailsApplication application = grailsApplication2;
        GrTypeDefinition publicClass = GroovyUtils.getPublicClass((Project)project2, (VirtualFile)file);
        if (publicClass == null) {
            String string = GrailsUtils.getControllerNameByGsp(file);
            if (string == null) {
                return null;
            }
            String controllerName = string;
            if (Intrinsics.areEqual((Object)controllerName, (Object)"layouts") || !StringUtil.isJavaIdentifier((String)controllerName)) {
                return null;
            }
            isView = true;
            packageName = null;
            String string2 = controllerName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"controllerName");
            artefactName = string2;
        } else {
            GrailsArtifact grailsArtifact;
            GrailsArtifact it;
            PsiClass artefactClass = GrailsUtils.isInGrailsTests(file, project2) ? GrailsTestUtils.getTestedClass((PsiClass)publicClass) : (PsiClass)publicClass;
            if (artefactClass == null) {
                return null;
            }
            isView = false;
            String string = artefactClass.getQualifiedName();
            if (string == null) {
                return null;
            }
            packageName = StringUtil.getPackageName((String)string);
            Object object = GrailsArtifact.getType(artefactClass);
            if (object == null || (object = (it = (grailsArtifact = object)).getArtifactName(artefactClass)) == null) {
                return null;
            }
            artefactName = object;
        }
        Project project3 = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        Module module3 = module2;
        Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
        VirtualFile virtualFile2 = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
        GrailsApplication grailsApplication3 = application;
        Intrinsics.checkExpressionValueIsNotNull((Object)grailsApplication3, (String)"application");
        return new ArtefactData(project3, module3, virtualFile2, packageName, (String)artefactName, grailsApplication3, isView);
    }

    @Nullable
    public static final GrailsApplication getGrailsApplication(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        GrailsApplication grailsApplication2 = (GrailsApplication)dataContext.getData(GRAILS_APPLICATION);
        if (grailsApplication2 != null) {
            GrailsApplication grailsApplication3;
            GrailsApplication it = grailsApplication3 = grailsApplication2;
            return it;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        GrailsApplicationManager instance = GrailsApplicationManager.getInstance(project2);
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return instance.findApplication(virtualFile2);
    }

    @Nullable
    public static final GrailsArtefactHandler getArtefactHandler(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        return (GrailsArtefactHandler)dataContext.getData(GRAILS_ARTEFACT_HANDLER);
    }

    @Nullable
    public static final String getArtefactPackage(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        return (String)dataContext.getData(GRAILS_ARTEFACT_PACKAGE);
    }

    static {
        DataKey dataKey = DataKey.create((String)"grails.application");
        Intrinsics.checkExpressionValueIsNotNull((Object)dataKey, (String)"DataKey.create(\"grails.application\")");
        GRAILS_APPLICATION = dataKey;
        DataKey dataKey2 = DataKey.create((String)"grails.artefact.handler");
        Intrinsics.checkExpressionValueIsNotNull((Object)dataKey2, (String)"DataKey.create(\"grails.artefact.handler\")");
        GRAILS_ARTEFACT_HANDLER = dataKey2;
        DataKey dataKey3 = DataKey.create((String)"grails.artefact.package");
        Intrinsics.checkExpressionValueIsNotNull((Object)dataKey3, (String)"DataKey.create(\"grails.artefact.package\")");
        GRAILS_ARTEFACT_PACKAGE = dataKey3;
    }
}

