/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleModuleBuilder;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.runner.GrailsConsole;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0005J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0015R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/grails/config/GrailsGradleAwareModuleBuilder;", "Lcom/intellij/ide/util/projectWizard/ModuleBuilder;", "()V", "isCreatingNewProject", "", "()Z", "setCreatingNewProject", "(Z)V", "parentProject", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "getParentProject", "()Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "setParentProject", "(Lcom/intellij/openapi/externalSystem/model/project/ProjectData;)V", "getModuleRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "linkGradleProject", "", "fresh", "rootProjectPath", "", "project", "Lcom/intellij/openapi/project/Project;", "linkModule", "setupModule", "Companion", "groovy-mvc"})
public abstract class GrailsGradleAwareModuleBuilder
extends ModuleBuilder {
    @Nullable
    private ProjectData parentProject;
    private boolean isCreatingNewProject;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Nullable
    public final ProjectData getParentProject() {
        return this.parentProject;
    }

    public final void setParentProject(@Nullable ProjectData projectData) {
        this.parentProject = projectData;
    }

    public final boolean isCreatingNewProject() {
        return this.isCreatingNewProject;
    }

    public final void setCreatingNewProject(boolean bl) {
        this.isCreatingNewProject = bl;
    }

    protected void setupModule(@NotNull Module module) throws ConfigurationException {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        super.setupModule(module);
        if (this.isCreatingNewProject) {
            module.getProject().putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
        }
    }

    protected final void linkModule(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Project project = module.getProject();
        VirtualFile root = this.getModuleRoot(module);
        Object object = this.parentProject;
        if (object == null || (object = object.getLinkedExternalProjectPath()) == null) {
            object = FileUtil.toCanonicalPath((String)(this.isCreatingNewProject ? module.getProject().getBasePath() : root.getPath()));
        }
        Object rootProjectPath = object;
        boolean fresh = this.isCreatingNewProject || this.parentProject == null;
        ApplicationManager.getApplication().runWriteAction(new Runnable((String)rootProjectPath, root, project, module, fresh){
            final /* synthetic */ String $rootProjectPath;
            final /* synthetic */ VirtualFile $root;
            final /* synthetic */ Project $project;
            final /* synthetic */ Module $module;
            final /* synthetic */ boolean $fresh;

            public final void run() {
                try {
                    GradleModuleBuilder.setupGradleSettingsFile((String)this.$rootProjectPath, (VirtualFile)this.$root, (String)this.$project.getName(), (String)this.$module.getName(), (boolean)this.$fresh);
                    GrailsGradleAwareModuleBuilder.Companion.getLOG().debug("'settings.gradle' file set up for module: " + this.$module);
                }
                catch (ConfigurationException e) {
                    GrailsGradleAwareModuleBuilder.Companion.getLOG().debug((Throwable)e);
                    String string = e.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    GrailsConsole.NOTIFICATION_GROUP.createNotification("Failed to create settings.gradle", string, NotificationType.WARNING, null).notify(this.$project);
                }
            }
            {
                this.$rootProjectPath = string;
                this.$root = virtualFile;
                this.$project = project;
                this.$module = module;
                this.$fresh = bl;
            }
        });
        Object object2 = rootProjectPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"rootProjectPath");
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        this.linkGradleProject(fresh, (String)object2, project2);
    }

    private final void linkGradleProject(boolean fresh, String rootProjectPath, Project project) {
        if (fresh) {
            GradleProjectSettings gradleSettings = new GradleProjectSettings();
            gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
            gradleSettings.setExternalProjectPath(rootProjectPath);
            ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)gradleSettings);
            Companion.getLOG().debug("Project '" + project + "' linked with " + gradleSettings);
        }
        if (!this.isCreatingNewProject) {
            FileDocumentManager.getInstance().saveAllDocuments();
            Companion.getLOG().debug("Starting refreshing the project: " + rootProjectPath);
        }
        ExternalSystemUtil.refreshProject((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)rootProjectPath, (boolean)false, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    @NotNull
    protected final VirtualFile getModuleRoot(@NotNull Module module) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (((Object[])roots).length == 1) {
            VirtualFile virtualFile = roots[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"roots[0]");
            return virtualFile;
        }
        throw (Throwable)new ExecutionException("There is no module root");
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(GrailsGradleAwareModuleBuilder.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/grails/config/GrailsGradleAwareModuleBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "groovy-mvc"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

