/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.sdk.GrailsSDKManager;
import org.jetbrains.plugins.grails.ui.GrailsSDKHomeForm;
import org.jetbrains.plugins.grails.util.version.Version;

public class GrailsProjectStructureDetector
extends ProjectStructureDetector {
    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File dir, @NotNull File[] children, @NotNull File base, @NotNull List<DetectedProjectRoot> result2) {
        if (dir == null) {
            GrailsProjectStructureDetector.$$$reportNull$$$0(0);
        }
        if (children == null) {
            GrailsProjectStructureDetector.$$$reportNull$$$0(1);
        }
        if (base == null) {
            GrailsProjectStructureDetector.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            GrailsProjectStructureDetector.$$$reportNull$$$0(3);
        }
        if (GrailsProjectStructureDetector.hasFilename(children, "grails-app", false) && GrailsProjectStructureDetector.hasFilename(children, "application.properties", true) && new File(new File(new File(dir, "grails-app"), "conf"), "BuildConfig.groovy").exists()) {
            result2.add(new GrailsDetectedProjectRoot(dir));
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
            if (directoryProcessingResult == null) {
                GrailsProjectStructureDetector.$$$reportNull$$$0(4);
            }
            return directoryProcessingResult;
        }
        ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
        if (directoryProcessingResult == null) {
            GrailsProjectStructureDetector.$$$reportNull$$$0(5);
        }
        return directoryProcessingResult;
    }

    public List<ModuleWizardStep> createWizardSteps(ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, Icon stepIcon) {
        ModuleWizardStep javaSdkStep = ProjectWizardStepFactory.getInstance().createProjectJdkStep(builder.getContext());
        GrailsSDKWizardStep groovySdkStep = new GrailsSDKWizardStep(builder, this);
        return Arrays.asList(new ModuleWizardStep[]{javaSdkStep, groovySdkStep});
    }

    private static boolean hasFilename(File[] children, String name, boolean isFile) {
        for (File child : children) {
            if (!(isFile ? child.isFile() : child.isDirectory()) || !child.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectRoots";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GrailsSDKWizardStep
    extends ModuleWizardStep {
        private final GrailsSDKHomeForm myForm = new GrailsSDKHomeForm().setVersionRange(Version.LESS_THAN_3);
        private final ProjectFromSourcesBuilder myFromSourcesBuilder;
        private final GrailsProjectStructureDetector myDetector;

        public GrailsSDKWizardStep(ProjectFromSourcesBuilder builder, GrailsProjectStructureDetector detector) {
            this.myForm.setPath(PropertiesComponent.getInstance().getValue("grails.last.selected.sdk.home"));
            this.myFromSourcesBuilder = builder;
            this.myDetector = detector;
        }

        public JComponent getComponent() {
            return this.myForm.getComponent();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myForm.getPathComponent();
        }

        public boolean validate() throws ConfigurationException {
            return this.myForm.validate();
        }

        public void updateDataModel() {
            List modules = this.myFromSourcesBuilder.getProjectRoots((ProjectStructureDetector)this.myDetector).stream().map(root -> {
                final File directory = root.getDirectory();
                ModuleDescriptor descriptor = new ModuleDescriptor(directory, StdModuleTypes.JAVA, Collections.emptyList());
                descriptor.addConfigurationUpdater(new ModuleBuilder.ModuleConfigurationUpdater(){

                    public void update(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
                        if (module == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (rootModel == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        GrailsSDKManager.getInstance(module.getProject()).setGrailsSDK(directory.getAbsolutePath(), myForm.getSelectedSdk().getPath());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "module";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "rootModel";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector$GrailsSDKWizardStep$1";
                        objectArray[2] = "update";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                return descriptor;
            }).collect(Collectors.toList());
            this.myFromSourcesBuilder.getProjectDescriptor((ProjectStructureDetector)this.myDetector).setModules(modules);
        }
    }

    private static class GrailsDetectedProjectRoot
    extends DetectedProjectRoot {
        protected GrailsDetectedProjectRoot(@NotNull File directory) {
            if (directory == null) {
                GrailsDetectedProjectRoot.$$$reportNull$$$0(0);
            }
            super(directory);
        }

        @NotNull
        public String getRootTypeName() {
            if ("Grails" == null) {
                GrailsDetectedProjectRoot.$$$reportNull$$$0(1);
            }
            return "Grails";
        }

        public boolean canContainRoot(@NotNull DetectedProjectRoot root) {
            if (root == null) {
                GrailsDetectedProjectRoot.$$$reportNull$$$0(2);
            }
            return GrailsDetectedProjectRoot.class.equals(root.getClass());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector$GrailsDetectedProjectRoot";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector$GrailsDetectedProjectRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootTypeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canContainRoot";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

