/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsStructure;

class GrailsPropertiesFileCache {
    private PropertiesFileImpl myPropertiesFile;
    private long myModificationCount;
    private String myAppName;

    GrailsPropertiesFileCache(GrailsStructure grailsStructure) {
        PsiFile file;
        PropertiesFileImpl prop = null;
        VirtualFile child = grailsStructure.getAppRoot().findChild("application.properties");
        if (child != null && (file = grailsStructure.getManager().findFile(child)) instanceof PropertiesFileImpl) {
            prop = (PropertiesFileImpl)file;
        }
        if (prop != null) {
            String value;
            this.myPropertiesFile = prop;
            this.myModificationCount = prop.getModificationStamp();
            IProperty appNameProperty = prop.findPropertyByKey("app.name");
            if (appNameProperty != null && !StringUtil.isEmptyOrSpaces((String)(value = appNameProperty.getValue()))) {
                this.myAppName = value.trim();
            }
        }
    }

    boolean isOutdated() {
        return this.myPropertiesFile != null && (!this.myPropertiesFile.isValid() || this.myModificationCount != this.myPropertiesFile.getModificationStamp());
    }

    @Nullable
    public String getAppName() {
        return this.myAppName;
    }
}

