/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.database;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GroovyConfigReader;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GrailsDataSourceDetector
extends DataSourceDetector {
    public boolean isRelevantFile(@NotNull PsiFile file) {
        if (file == null) {
            GrailsDataSourceDetector.$$$reportNull$$$0(0);
        }
        if (!file.getName().equals("DataSource.groovy")) {
            return false;
        }
        VirtualFile dataSourceFile = file.getVirtualFile();
        if (dataSourceFile == null) {
            return false;
        }
        VirtualFile confDir = dataSourceFile.getParent();
        if (confDir == null || !confDir.getName().equals("conf")) {
            return false;
        }
        VirtualFile grailsAppDir = confDir.getParent();
        return grailsAppDir != null && grailsAppDir.getName().equals("grails-app");
    }

    public void collectDataSources(@NotNull Module module, @NotNull DataSourceDetector.Builder builder, boolean onTheFly) {
        GrailsFramework framework;
        if (module == null) {
            GrailsDataSourceDetector.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            GrailsDataSourceDetector.$$$reportNull$$$0(2);
        }
        if (!(framework = GrailsFramework.getInstance()).hasSupport(module)) {
            return;
        }
        VirtualFile confDirectory = GrailsUtils.findConfDirectory(module);
        if (confDirectory == null) {
            return;
        }
        VirtualFile dataSource = confDirectory.findChild("DataSource.groovy");
        if (dataSource == null) {
            return;
        }
        PsiFile psiDataSource = PsiManager.getInstance((Project)module.getProject()).findFile(dataSource);
        if (!(psiDataSource instanceof GroovyFile)) {
            return;
        }
        GroovyConfigReader cfg = GroovyConfigReader.read((GroovyFile)psiDataSource);
        PsiElement urlElement = cfg.getValue("development", "dataSource.url");
        if (urlElement == null) {
            return;
        }
        String driver = cfg.getStringValue("development", "dataSource.driverClassName");
        if (StringUtil.isEmpty((String)driver) || driver.equals("org.h2.Driver")) {
            return;
        }
        String url = cfg.getStringValue("development", "dataSource.url");
        if (StringUtil.isEmpty((String)url)) {
            return;
        }
        String dataSourceName = module.getName() + " dev";
        if (onTheFly && DbUtil.getDataSources((Project)module.getProject()).filter(DasUtil.byName((String)dataSourceName)).isNotEmpty()) {
            return;
        }
        String userName = cfg.getStringValue("development", "dataSource.username");
        if (StringUtil.isEmpty((String)userName)) {
            return;
        }
        String password = cfg.getStringValue("development", "dataSource.password");
        if (StringUtil.isEmpty((String)password)) {
            return;
        }
        builder.withName(dataSourceName).withDriverClass(driver).withUrl(url).withUser(userName).withPassword(password).withDriverPath(GrailsDataSourceDetector.findJarByClassName(module, driver)).commit("grails", (Object)urlElement);
    }

    @Nullable
    private static String findJarByClassName(@NotNull Module module, @NotNull String className) {
        PsiClass driverClass;
        if (module == null) {
            GrailsDataSourceDetector.$$$reportNull$$$0(3);
        }
        if (className == null) {
            GrailsDataSourceDetector.$$$reportNull$$$0(4);
        }
        if ((driverClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(className, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false))) == null) {
            return null;
        }
        VirtualFile classFile = driverClass.getContainingFile().getVirtualFile();
        if (classFile == null) {
            return null;
        }
        if (!(classFile.getFileSystem() instanceof JarFileSystem)) {
            return className;
        }
        VirtualFile jar = JarFileSystem.getInstance().getLocalByEntry(classFile);
        if (jar == null) {
            return null;
        }
        return jar.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/database/GrailsDataSourceDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRelevantFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDataSources";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findJarByClassName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

