/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.gson;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrScriptField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0011\u001a\u0010\u0010\u0012\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000b\u001a\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"findModelClosure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "file", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFile;", "getGsonTemplateName", "", "fileName", "getModelFields", "", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrScriptField;", "element", "Lcom/intellij/psi/PsiElement;", "scriptClass", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass;", "getScriptClass", "isGsonFile", "", "Lcom/intellij/psi/PsiFile;", "isGsonTemplate", "isModelVariable", "variable", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariable;", "groovy-mvc"})
public final class GsonUtilsKt {
    public static final boolean isGsonFile(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return StringsKt.endsWith$default((String)file.getName(), (String)".gson", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final List<GrScriptField> getModelFields(@Nullable PsiElement element) {
        return GsonUtilsKt.getModelFields(GsonUtilsKt.getScriptClass(element));
    }

    @Nullable
    public static final GroovyScriptClass getScriptClass(@Nullable PsiElement element) {
        PsiFile gsonView;
        PsiFile psiFile;
        Object v3;
        block5: {
            Iterable iterable;
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrField.class, GrMethod.class});
            if (!(psiElement instanceof GrMember)) {
                psiElement = null;
            }
            GrMember grMember = (GrMember)psiElement;
            if (grMember == null) {
                return null;
            }
            GrMember action = grMember;
            Iterable iterable2 = iterable = (Iterable)GrailsUtils.getViewPsiByAction((PsiElement)action);
            for (Object t : iterable2) {
                PsiFile it;
                PsiFile psiFile2 = it = (PsiFile)t;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"it");
                if (!GsonUtilsKt.isGsonFile(psiFile2)) continue;
                v3 = t;
                break block5;
            }
            v3 = null;
        }
        if (!((psiFile = (gsonView = (PsiFile)v3)) instanceof GroovyFile)) {
            psiFile = null;
        }
        GroovyFile groovyFile = (GroovyFile)psiFile;
        Object object = groovyFile != null ? groovyFile.getScriptClass() : null;
        if (!(object instanceof GroovyScriptClass)) {
            object = null;
        }
        return (GroovyScriptClass)object;
    }

    @NotNull
    public static final List<GrScriptField> getModelFields(@Nullable GroovyScriptClass scriptClass) {
        if (scriptClass == null) {
            return CollectionsKt.emptyList();
        }
        return ArraysKt.filterIsInstance((Object[])scriptClass.getFields(), GrScriptField.class);
    }

    public static final boolean isModelVariable(@NotNull PsiElement variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        return variable instanceof GrVariable && GsonUtilsKt.isModelVariable((GrVariable)variable);
    }

    public static final boolean isModelVariable(@NotNull GrVariable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        PsiElement psiElement = variable.getParent();
        Object object = psiElement != null ? psiElement.getParent() : null;
        if (!(object instanceof GrClosableBlock)) {
            object = null;
        }
        GrClosableBlock grClosableBlock = (GrClosableBlock)object;
        if (grClosableBlock == null) {
            return false;
        }
        GrClosableBlock closure = grClosableBlock;
        PsiFile psiFile = variable.getContainingFile();
        if (!(psiFile instanceof GroovyFile)) {
            psiFile = null;
        }
        GroovyFile groovyFile = (GroovyFile)psiFile;
        if (groovyFile == null) {
            return false;
        }
        GroovyFile file = groovyFile;
        return Intrinsics.areEqual((Object)closure, (Object)GsonUtilsKt.findModelClosure(file));
    }

    @Nullable
    public static final GrClosableBlock findModelClosure(@NotNull GroovyFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        GrTopStatement[] grTopStatementArray = file.getTopStatements();
        for (int i = 0; i < grTopStatementArray.length; ++i) {
            GrTopStatement statement = grTopStatementArray[i];
            if (!(statement instanceof GrMethodCallExpression)) continue;
            GrExpression grExpression = ((GrMethodCallExpression)statement).getInvokedExpression();
            if (!(grExpression instanceof GrReferenceExpression)) {
                grExpression = null;
            }
            GrReferenceExpression grReferenceExpression = (GrReferenceExpression)grExpression;
            if (Intrinsics.areEqual((Object)"model", (Object)(grReferenceExpression != null ? grReferenceExpression.getReferenceName() : null)) ^ true) continue;
            GrClosableBlock[] arguments = ((GrMethodCallExpression)statement).getClosureArguments();
            return ((Object[])arguments).length == 1 ? arguments[0] : null;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGsonTemplate(@Nullable PsiElement element) {
        if (!(element instanceof GroovyFile)) return false;
        if (!((GroovyFile)element).isScript()) return false;
        VirtualFile virtualFile = ((GroovyFile)element).getVirtualFile();
        if (virtualFile == null) return false;
        VirtualFile virtualFile2 = virtualFile;
        VirtualFile it = virtualFile2;
        if (!StringsKt.startsWith$default((CharSequence)it.getNameSequence(), (CharSequence)"_", (boolean)false, (int)2, null)) return false;
        if (!StringsKt.endsWith$default((CharSequence)it.getNameSequence(), (CharSequence)".gson", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Nullable
    public static final String getGsonTemplateName(@NotNull GroovyFile file) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (GsonUtilsKt.isGsonTemplate((PsiElement)file)) {
            String string2 = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
            string = GsonUtilsKt.getGsonTemplateName(string2);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String getGsonTemplateName(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)fileName, (CharSequence)"_"), (CharSequence)".gson");
    }
}

