/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.editor.actions;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.lang.gsp.editor.actions.GspEditorActionsUtil;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.groovy.api.GspGroovyFile;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.groovy.editor.HandlerUtils;

public class GspEnterHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            GspEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GspEnterHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            GspEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            GspEnterHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            GspEnterHandler.$$$reportNull$$$0(4);
        }
        if (!(file instanceof GspFile) && !(file instanceof GspGroovyFile) || HandlerUtils.isReadOnly((Editor)editor)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caret = editor.getCaretModel().getOffset();
        if (caret < 1) {
            return EnterHandlerDelegate.Result.Continue;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(caret - 1);
        IElementType tokenType = iterator.getTokenType();
        if (tokenType == GspTokenTypes.JSCRIPT_BEGIN || tokenType == GspTokenTypes.GSCRIPT_BEGIN) {
            boolean isJLike;
            boolean bl = isJLike = tokenType == GspTokenTypes.JSCRIPT_BEGIN;
            if (!GspEditorActionsUtil.areSciptletSeparatorsUnbalanced(iterator)) {
                originalHandler.execute(editor, dataContext);
            } else {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(isJLike ? "%>" : "}%"));
                editor.getCaretModel().moveCaretRelatively(-2, 0, false, false, true);
                originalHandler.execute(editor, dataContext);
                if (isJLike) {
                    originalHandler.execute(editor, dataContext);
                    editor.getCaretModel().moveCaretRelatively(0, -1, false, false, true);
                }
            }
            GspEditorActionsUtil.insertSpacesByGspIndent(editor, file.getProject());
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/grails/lang/gsp/editor/actions/GspEnterHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

