/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.editor.actions;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.ide.DataManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import java.awt.Component;
import org.jetbrains.plugins.grails.addins.js.JavaScriptIntegrationUtil;
import org.jetbrains.plugins.grails.lang.gsp.editor.actions.GspEditorActionsUtil;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.groovy.editor.HandlerUtils;

public class GspTypedHandler
extends TypedHandlerDelegate {
    private static final Logger LOG = Logger.getInstance(GspTypedHandler.class);

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        if (GspTypedHandler.handleTyping(editor, c, project)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean handleTyping(Editor editor, char charTyped, Project project) {
        if (project == null || !HandlerUtils.canBeInvoked((Editor)editor, (Project)project)) {
            return false;
        }
        PsiFile file = HandlerUtils.getPsiFile((Editor)editor, (Project)project);
        if (!(file instanceof GspFile)) {
            return false;
        }
        int caret = editor.getCaretModel().getOffset();
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        if (caret < 1) {
            return false;
        }
        HighlighterIterator iterator = highlighter.createIterator(caret - 1);
        IElementType tokenType = iterator.getTokenType();
        CharSequence text = editor.getDocument().getCharsSequence();
        if (tokenType == GspTokenTypes.JSCRIPT_BEGIN && GspEditorActionsUtil.areSciptletSeparatorsUnbalanced(highlighter.createIterator(caret - 1))) {
            if ('=' == charTyped) {
                return GspTypedHandler.handleJspLikeEqualTyped(editor, text, caret);
            }
            if ('@' == charTyped) {
                return GspTypedHandler.handleJspLikeDirectiveTyped(editor, text, caret);
            }
            if ('!' == charTyped) {
                return GspTypedHandler.handleJspLikeDeclarationTyped(editor, text, caret);
            }
        }
        if ('/' == charTyped && tokenType == XmlTokenType.XML_TAG_NAME && caret == iterator.getEnd()) {
            return GspTypedHandler.handleSlash(editor, text, caret, iterator);
        }
        if ('{' == charTyped) {
            if (tokenType == XmlTokenType.XML_DATA_CHARACTERS || JavaScriptIntegrationUtil.isJSElementType(tokenType)) {
                return GspTypedHandler.handleGspLeftBraceTyped(editor, text, caret, false, project);
            }
            if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                return GspTypedHandler.handleGspLeftBraceTyped(editor, text, caret, true, project);
            }
            if (tokenType == GspTokenTypes.GSTRING_DOLLAR) {
                iterator.advance();
                if (iterator.getTokenType() == GspTokenTypes.GSP_ATTRIBUTE_VALUE_TOKEN) {
                    return GspTypedHandler.handleGspLeftBraceTyped(editor, text, caret, true, project);
                }
            }
        }
        if ('}' == charTyped) {
            return GspTypedHandler.handleGspRightBraceTyped(editor, text, caret);
        }
        if ('[' == charTyped && tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            iterator.advance();
            if (iterator.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"[]");
                editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
                return true;
            }
        }
        return false;
    }

    private static boolean handleSlash(Editor editor, CharSequence text, int caret, HighlighterIterator iterator) {
        for (int i = iterator.getStart(); i < caret; ++i) {
            if (text.charAt(i) != ':') continue;
            if ("tmpl".contentEquals(text.subSequence(iterator.getStart(), i))) {
                return false;
            }
            if (caret < text.length() && text.charAt(caret) == '>') {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"/");
            } else {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"/>");
            }
            return true;
        }
        return false;
    }

    private static boolean handleGspRightBraceTyped(Editor editor, CharSequence text, int caret) {
        if (caret == 0 || text.length() < 2 || text.length() < caret + 1) {
            return false;
        }
        if (GspTypedHandler.mustNotPlaceBrace(editor, caret)) {
            editor.getCaretModel().moveCaretRelatively(1, 0, false, false, true);
            return true;
        }
        return false;
    }

    private static boolean mustNotPlaceBrace(Editor editor, int caret) {
        String text = editor.getDocument().getText();
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        if (caret < 1) {
            return false;
        }
        HighlighterIterator iterator = highlighter.createIterator(caret);
        return text.charAt(caret) == '}' && iterator.getTokenType() == GspTokenTypes.GEXPR_END;
    }

    private static boolean handleGspLeftBraceTyped(Editor editor, CharSequence text, int caret, boolean inGrailsTagArgValue, Project project) {
        if (caret < 1 || text.length() < Math.min(caret - 1, 1)) {
            return false;
        }
        EditorActionManager manager = EditorActionManager.getInstance();
        EditorActionHandler handler = manager.getActionHandler("EditorEnter");
        LOG.assertTrue(project != null);
        if (text.charAt(caret - 1) == '$') {
            if (text.length() > caret && text.charAt(caret) == '}') {
                return false;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{}");
            editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
            return true;
        }
        if (!inGrailsTagArgValue && text.charAt(caret - 1) == '@') {
            if (text.length() > caret && text.charAt(caret) == '}') {
                return false;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{  }");
            editor.getCaretModel().moveCaretRelatively(-2, 0, false, false, true);
            return true;
        }
        if (!inGrailsTagArgValue && text.charAt(caret - 1) == '!') {
            if (text.length() > caret && text.charAt(caret) == '}') {
                return false;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{}!");
            editor.getCaretModel().moveCaretRelatively(-2, 0, false, false, true);
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            handler.execute(editor, DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
            GspEditorActionsUtil.insertSpacesByGspIndent(editor, project);
            return true;
        }
        return false;
    }

    private static boolean handleJspLikeEqualTyped(Editor editor, CharSequence text, int caret) {
        if (caret < 2 || text.length() < Math.min(caret - 2, 2)) {
            return false;
        }
        if (text.charAt(caret - 1) == '%' && text.charAt(caret - 2) == '<') {
            if (text.length() > caret && text.charAt(caret) == '%') {
                return false;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"=  %>");
            editor.getCaretModel().moveCaretRelatively(-3, 0, false, false, true);
            return true;
        }
        return false;
    }

    private static boolean handleJspLikeDirectiveTyped(Editor editor, CharSequence text, int caret) {
        if (caret < 2 || text.length() < Math.min(caret - 2, 2)) {
            return false;
        }
        if (text.charAt(caret - 1) == '%' && text.charAt(caret - 2) == '<') {
            if (text.length() > caret && text.charAt(caret) == '%') {
                return false;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"@  %>");
            editor.getCaretModel().moveCaretRelatively(-3, 0, false, false, true);
            return true;
        }
        return false;
    }

    private static boolean handleJspLikeDeclarationTyped(Editor editor, CharSequence text, int caret) {
        if (caret < 2 || text.length() < Math.min(caret - 2, 2)) {
            return false;
        }
        if (text.charAt(caret - 1) == '%' && text.charAt(caret - 2) == '<') {
            if (text.length() > caret && text.charAt(caret) == '%') {
                return false;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"!  %>");
            editor.getCaretModel().moveCaretRelatively(-3, 0, false, false, true);
            return true;
        }
        return false;
    }
}

