/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.parsing.gsp;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.lang.gsp.GspLanguage;
import org.jetbrains.plugins.grails.lang.gsp.lexer.GspTokenTypesEx;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.grails.lang.gsp.parsing.GspPsiCreator;
import org.jetbrains.plugins.grails.lang.gsp.parsing.gsp.GspParser;
import org.jetbrains.plugins.grails.lang.gsp.parsing.gsp.lexer.GspLexer;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.GspFileImpl;

public class GspParserDefinition
implements ParserDefinition {
    public static final IFileElementType GSP_FILE = new IFileElementType("GSP File", (Language)GspLanguage.INSTANCE);
    private static TokenSet whitespaceTokens;

    @NotNull
    public Lexer createLexer(Project project) {
        GspLexer gspLexer = new GspLexer(){

            @Override
            public IElementType getTokenType() {
                IElementType type = super.getTokenType();
                if (type == GSP_WHITE_SPACE) {
                    return XmlTokenType.XML_WHITE_SPACE;
                }
                if (type == GTAG_START_TAG_START) {
                    return XmlTokenType.XML_START_TAG_START;
                }
                if (type == GTAG_END_TAG_START) {
                    return XmlTokenType.XML_END_TAG_START;
                }
                if (type == GTAG_START_TAG_END) {
                    return XmlTokenType.XML_EMPTY_ELEMENT_END;
                }
                if (type == GTAG_TAG_END) {
                    return XmlTokenType.XML_TAG_END;
                }
                if (type == GSP_TAG_NAME) {
                    return XmlTokenType.XML_TAG_NAME;
                }
                if (type == GSP_ATTR_NAME) {
                    return XmlTokenType.XML_NAME;
                }
                if (type == GSP_ATTRIBUTE_VALUE_TOKEN) {
                    return XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
                }
                if (type == GSP_ATTR_VALUE_START_DELIMITER) {
                    return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
                }
                if (type == GSP_ATTR_VALUE_END_DELIMITER) {
                    return XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
                }
                if (type == GSP_EQ) {
                    return XmlTokenType.XML_EQ;
                }
                return type;
            }
        };
        if (gspLexer == null) {
            GspParserDefinition.$$$reportNull$$$0(0);
        }
        return gspLexer;
    }

    public PsiParser createParser(Project project) {
        return new GspParser();
    }

    public IFileElementType getFileNodeType() {
        return GSP_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        if (whitespaceTokens == null) {
            whitespaceTokens = TokenSet.create((IElementType[])new IElementType[]{GspTokenTypes.GSP_WHITE_SPACE, XmlTokenType.XML_WHITE_SPACE});
        }
        TokenSet tokenSet = whitespaceTokens;
        if (tokenSet == null) {
            GspParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = GspTokenTypesEx.GSP_COMMENTS;
        if (tokenSet == null) {
            GspParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            GspParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement psiElement = GspPsiCreator.createElement(node);
        if (psiElement == null) {
            GspParserDefinition.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new GspFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        if (GspTokenTypesEx.GSP_GROOVY_SEPARATORS.contains(left.getElementType()) || GspTokenTypesEx.GSP_GROOVY_SEPARATORS.contains(right.getElementType())) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/grails/lang/gsp/parsing/gsp/GspParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

