/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.pluginSupport.buildTestData.GrailsBuildTestDataMemberProvider;
import org.jetbrains.plugins.grails.pluginSupport.seachable.GrailsSearchableMemberProvider;
import org.jetbrains.plugins.grails.references.MemberProvider;
import org.jetbrains.plugins.grails.references.bootstrap.GrailsBootStrapMemberProvider;
import org.jetbrains.plugins.grails.references.controller.ControllerMembersProvider;
import org.jetbrains.plugins.grails.references.domain.DomainMembersProvider;
import org.jetbrains.plugins.grails.references.filter.FilterMemberProvider;
import org.jetbrains.plugins.grails.references.jobs.JobsMemberProvider;
import org.jetbrains.plugins.grails.references.taglib.TaglibMembersProvider;
import org.jetbrains.plugins.grails.references.urlMappings.UrlMappingMemberProvider;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsPsiUtil;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrailsArtifactNonCodeMemberProcessor
extends NonCodeMembersContributor {
    private static volatile Map<GrailsArtifact, MemberProvider[]> MAP;

    public static Map<GrailsArtifact, MemberProvider[]> getMemberProviderMap() {
        Map<GrailsArtifact, MemberProvider[]> res = MAP;
        if (res == null) {
            res = new EnumMap<GrailsArtifact, MemberProvider[]>(GrailsArtifact.class);
            res.put(GrailsArtifact.CONTROLLER, new MemberProvider[]{new ControllerMembersProvider()});
            res.put(GrailsArtifact.DOMAIN, new MemberProvider[]{new DomainMembersProvider(), new GrailsSearchableMemberProvider(), new GrailsBuildTestDataMemberProvider()});
            res.put(GrailsArtifact.TAGLIB, new MemberProvider[]{new TaglibMembersProvider()});
            res.put(GrailsArtifact.JOB, new MemberProvider[]{new JobsMemberProvider()});
            res.put(GrailsArtifact.FILTER, new MemberProvider[]{new FilterMemberProvider()});
            res.put(GrailsArtifact.URLMAPPINGS, new MemberProvider[]{new UrlMappingMemberProvider()});
            res.put(GrailsArtifact.BOOTSTRAP, new MemberProvider[]{new GrailsBootStrapMemberProvider()});
            MAP = res;
        }
        return res;
    }

    private static boolean isTagLibByPackage(@NotNull PsiClass aClass) {
        String qualifiedName;
        if (aClass == null) {
            GrailsArtifactNonCodeMemberProcessor.$$$reportNull$$$0(0);
        }
        return (qualifiedName = aClass.getQualifiedName()) != null && qualifiedName.endsWith("TagLib") && qualifiedName.startsWith("org.codehaus.groovy.grails.plugins.web.taglib.");
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass psiClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (qualifierType == null) {
            GrailsArtifactNonCodeMemberProcessor.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            GrailsArtifactNonCodeMemberProcessor.$$$reportNull$$$0(2);
        }
        if (place == null) {
            GrailsArtifactNonCodeMemberProcessor.$$$reportNull$$$0(3);
        }
        if (state == null) {
            GrailsArtifactNonCodeMemberProcessor.$$$reportNull$$$0(4);
        }
        if (psiClass == null) {
            return;
        }
        GrailsArtifact artifact = (GrailsArtifact)((Object)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create((Object)((Object)GrailsArtifactNonCodeMemberProcessor.getArtifact(psiClass)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT})));
        if (artifact == null) {
            return;
        }
        if (!GrailsPsiUtil.processLogVariable(processor, psiClass, ResolveUtil.getNameHint((PsiScopeProcessor)processor))) {
            return;
        }
        MemberProvider[] providers = GrailsArtifactNonCodeMemberProcessor.getMemberProviderMap().get((Object)artifact);
        if (providers != null) {
            for (MemberProvider provider : providers) {
                provider.processMembers(processor, psiClass, place);
            }
        }
    }

    @Nullable
    private static GrailsArtifact getArtifact(@NotNull PsiClass psiClass) {
        GrailsArtifact artifact;
        if (psiClass == null) {
            GrailsArtifactNonCodeMemberProcessor.$$$reportNull$$$0(5);
        }
        return (artifact = GrailsUtils.calculateArtifactType(psiClass)) != null ? artifact : (GrailsArtifactNonCodeMemberProcessor.isTagLibByPackage(psiClass) ? GrailsArtifact.TAGLIB : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/references/GrailsArtifactNonCodeMemberProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTagLibByPackage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processDynamicElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getArtifact";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

