/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class PluginSupportFileReferenceSet
extends FileReferenceSet {
    public PluginSupportFileReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed, boolean init) {
        if (str == null) {
            PluginSupportFileReferenceSet.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PluginSupportFileReferenceSet.$$$reportNull$$$0(1);
        }
        super(str, element, startInElement, provider, isCaseSensitive, endingSlashNotAllowed, null, init);
    }

    public MyFileReference createNonPluginFileReference(TextRange range, int index, String text) {
        return new MyFileReference(this, range, index, text);
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return new Condition<PsiFileSystemItem>(){
            private final ProjectFileIndex fileIndex;
            {
                this.fileIndex = ProjectRootManager.getInstance((Project)PluginSupportFileReferenceSet.this.getElement().getProject()).getFileIndex();
            }

            public boolean value(PsiFileSystemItem psiFileSystemItem) {
                VirtualFile fileOrDir = psiFileSystemItem.getVirtualFile();
                if (fileOrDir != null && this.fileIndex.isInContent(fileOrDir)) {
                    return PluginSupportFileReferenceSet.this.isAcceptToCompletion(fileOrDir);
                }
                return false;
            }
        };
    }

    protected boolean isAcceptToCompletion(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            PluginSupportFileReferenceSet.$$$reportNull$$$0(2);
        }
        return fileOrDir.isDirectory();
    }

    public final FileReference createFileReference(TextRange range, int index, String text) {
        if (index == 0 && text.equals("plugins") && this.isAbsolutePathReference()) {
            return new PluginDirReference(this, range, index, text);
        }
        return this.createNonPluginFileReference(range, index, text);
    }

    protected boolean isPluginMustHasVersion() {
        return false;
    }

    @Nullable
    protected VirtualFile getContextInPlugin(@NotNull VirtualFile pluginRoot) {
        if (pluginRoot == null) {
            PluginSupportFileReferenceSet.$$$reportNull$$$0(3);
        }
        return pluginRoot;
    }

    protected PsiElement doSetTextToElement(String text) {
        ElementManipulator manipulator = CachingReference.getManipulator((PsiElement)this.getElement());
        return manipulator.handleContentChange(this.getElement(), text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginRoot";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptToCompletion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextInPlugin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PluginDirReference
    extends FileReference {
        public PluginDirReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
            if (fileReferenceSet == null) {
                PluginDirReference.$$$reportNull$$$0(0);
            }
            super(fileReferenceSet, range, index, text);
            assert (index == 0);
            assert (text.equals("plugins"));
            assert (fileReferenceSet.isAbsolutePathReference());
        }

        @NotNull
        protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
            if (containingFile == null) {
                PluginDirReference.$$$reportNull$$$0(1);
            }
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)this.getElement().getContainingFile().getOriginalFile())};
            if (resolveResultArray == null) {
                PluginDirReference.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileReferenceSet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$PluginDirReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$PluginDirReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "innerResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "innerResolve";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MyFileReference
    extends FileReference {
        public MyFileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
            if (fileReferenceSet == null) {
                MyFileReference.$$$reportNull$$$0(0);
            }
            super(fileReferenceSet, range, index, text);
        }

        @Nullable
        private FileReference getPreviousReferenceInner() {
            return this.getIndex() == 0 ? null : this.getFileReferenceSet().getReference(this.getIndex() - 1);
        }

        @Nullable
        public FileReference getPreviousReference() {
            return this.getPreviousReferenceInner();
        }

        @NotNull
        public PluginSupportFileReferenceSet getFileReferenceSet() {
            PluginSupportFileReferenceSet pluginSupportFileReferenceSet = (PluginSupportFileReferenceSet)super.getFileReferenceSet();
            if (pluginSupportFileReferenceSet == null) {
                MyFileReference.$$$reportNull$$$0(1);
            }
            return pluginSupportFileReferenceSet;
        }

        @NotNull
        protected final ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
            FileReference contextReference;
            if (containingFile == null) {
                MyFileReference.$$$reportNull$$$0(2);
            }
            if ((contextReference = this.getPreviousReference()) instanceof PluginDirReference) {
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
                if (module == null) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        MyFileReference.$$$reportNull$$$0(3);
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                String text = this.getText();
                VirtualFile pluginDir = null;
                if (this.getFileReferenceSet().isPluginMustHasVersion()) {
                    for (VirtualFile root : GrailsFramework.getInstance().getAllPluginRoots(module, false)) {
                        if (!root.getName().equals(text)) continue;
                        pluginDir = root;
                        break;
                    }
                } else {
                    pluginDir = GrailsFramework.getInstance().findPluginRoot(module, text, true);
                }
                if (pluginDir == null) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        MyFileReference.$$$reportNull$$$0(4);
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                VirtualFile contextInPlugin = this.getFileReferenceSet().getContextInPlugin(pluginDir);
                if (contextInPlugin == null) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        MyFileReference.$$$reportNull$$$0(5);
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                PsiDirectory psiPluginDir = this.getElement().getManager().findDirectory(contextInPlugin);
                if (psiPluginDir == null) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        MyFileReference.$$$reportNull$$$0(6);
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)psiPluginDir)};
                if (resolveResultArray == null) {
                    MyFileReference.$$$reportNull$$$0(7);
                }
                return resolveResultArray;
            }
            ResolveResult[] resolveResultArray = super.innerResolve(caseSensitive, containingFile);
            if (resolveResultArray == null) {
                MyFileReference.$$$reportNull$$$0(8);
            }
            return resolveResultArray;
        }

        @NotNull
        protected final Collection<PsiFileSystemItem> getContexts() {
            FileReference prevRef = this.getPreviousReference();
            if (prevRef instanceof PluginDirReference) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    MyFileReference.$$$reportNull$$$0(9);
                }
                return list;
            }
            if (prevRef == null) {
                Collection collection = this.getFileReferenceSet().getDefaultContexts();
                if (collection == null) {
                    MyFileReference.$$$reportNull$$$0(10);
                }
                return collection;
            }
            ResolveResult[] resolveResults = prevRef.multiResolve(false);
            ArrayList<PsiFileSystemItem> result2 = new ArrayList<PsiFileSystemItem>(resolveResults.length);
            for (ResolveResult resolveResult : resolveResults) {
                if (resolveResult.getElement() == null) continue;
                result2.add((PsiFileSystemItem)resolveResult.getElement());
            }
            ArrayList<PsiFileSystemItem> arrayList = result2;
            if (arrayList == null) {
                MyFileReference.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        protected PsiElement doRename(VirtualFile dstVFile) {
            for (PsiFileSystemItem item : this.getContexts()) {
                VirtualFile vFile = item.getVirtualFile();
                if (vFile == null || !VfsUtil.isAncestor((VirtualFile)vFile, (VirtualFile)dstVFile, (boolean)false)) continue;
                String text = this.getElement().getText().substring(this.getFileReferenceSet().getStartInElement(), this.getRangeInElement().getStartOffset());
                String path = VfsUtilCore.getRelativePath((VirtualFile)dstVFile, (VirtualFile)vFile, (char)'/');
                if (!text.isEmpty()) {
                    path = text.endsWith("/") ? text + path : text + '/' + path;
                }
                assert (path != null);
                String newContent = this.pathToString(path);
                if (newContent == null) {
                    return this.getElement();
                }
                return this.getFileReferenceSet().doSetTextToElement(newContent);
            }
            FileReference prevRef = this.getPreviousReferenceInner();
            if (prevRef instanceof MyFileReference) {
                return ((MyFileReference)prevRef).doRename(dstVFile);
            }
            return this.getElement();
        }

        @Nullable
        protected String pathToString(@NotNull String path) {
            if (path == null) {
                MyFileReference.$$$reportNull$$$0(12);
            }
            return path;
        }

        public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
            PsiFileSystemItem fileSystemItem;
            VirtualFile dstVFile;
            if (element == null) {
                MyFileReference.$$$reportNull$$$0(13);
            }
            if ((dstVFile = (fileSystemItem = (PsiFileSystemItem)element).getVirtualFile()) == null) {
                throw new IncorrectOperationException("Cannot bind to non-physical element:" + element);
            }
            return this.doRename(dstVFile);
        }

        @NotNull
        public final Object[] getVariants() {
            if (this.getPreviousReference() instanceof PluginDirReference) {
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
                if (module == null) {
                    if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                        MyFileReference.$$$reportNull$$$0(14);
                    }
                    return ArrayUtil.EMPTY_OBJECT_ARRAY;
                }
                Object[] objectArray = GrailsUtils.createPluginVariants(module, this.getFileReferenceSet().isPluginMustHasVersion());
                if (objectArray == null) {
                    MyFileReference.$$$reportNull$$$0(15);
                }
                return objectArray;
            }
            Object[] objectArray = super.getVariants();
            if (objectArray == null) {
                MyFileReference.$$$reportNull$$$0(16);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileReferenceSet";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileReferenceSet";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "innerResolve";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContexts";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "innerResolve";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "pathToString";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

