/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.references.domain.namedQuery.NamedQueryDescriptor;
import org.jetbrains.plugins.grails.util.GrailsPsiUtil;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.util.dynamicMembers.DynamicMemberUtils;

public class DomainDescriptor {
    public static final String GORM_INSTANCE_API_CLASS = "org.grails.datastore.gorm.GormInstanceApi";
    public static final Object ADD_TO_METHOD_MARKER = "Gorm:DomainDescriptor:addToMethod";
    public static final Object DOMAIN_DYNAMIC_METHOD = "Gorm:DomainDescriptor:DynamicMethod";
    private static final String METACLASS_METHODS = "class DomainClass444 { Map<String, org.codehaus.groovy.grails.validation.ConstrainedProperty> getConstraints(){}\n /** @since 1.4 */\n public org.codehaus.groovy.grails.commons.GrailsDomainClass getDomainClass(){}\n public void setProperties(Object properties){}\n public org.springframework.validation.Errors getErrors() {}\n public void setErrors(org.springframework.validation.Errors errors) {}\n}";
    private static final String OLD_METHODS = "class OldDomainClassMethods<T> { public Long ident(){}\n public void lock(){}\n public static T lock(java.io.Serializable id){}\n public T refresh(){}\n public T save(){}\n public T save(java.util.Map args){}\n public T save(Boolean validate){}\n public T merge(){}\n public T merge(java.util.Map args){}\n public T attach(){}\n public boolean isAttached(){}\n public boolean instanceOf(Class aClass){}\n public T discard(){}\n public void delete(){}\n public void delete(java.util.Map args){}\n public boolean isDirty(){}\n public boolean isDirty(String fieldName){}\n public List<String> getDirtyPropertyNames(){}\n public Object getPersistentValue(String fieldName){}\n public boolean hasErrors(){}\n public void clearErrors(){}\n public boolean validate(){}\n public boolean validate(java.util.Map args){}\n public boolean validate(boolean b){}\n public boolean validate(java.util.List args){}\n public static T get(java.io.Serializable id){}\n public static T read(java.io.Serializable id){}\n public static T load(java.io.Serializable id){}\n public static List<T> getAll() {}\n public static List<T> getAll(java.util.List<java.io.Serializable> ids) {}\n public static Object withCriteria(groovy.lang.Closure callable) {}\n public static Object withCriteria(java.util.Map builderArgs, groovy.lang.Closure callable) {}\n public static grails.orm.HibernateCriteriaBuilder createCriteria() {}\n public static Integer count(){}\n public static boolean exists(java.io.Serializable id) {}\n public static List<T> list() {}\n public static List<T> list(java.util.Map args) {}\n public static List<T> findAll() {}\n public static List<T> findAll(T example) {}\n public static List<T> findAll(T example, java.util.Map args) {}\n public static List<T> findAll(String query) {}\n public static List<T> findAll(String query, java.util.Collection positionalParams) {}\n public static List<T> findAll(String query, java.util.Collection positionalParams, java.util.Map paginateParams) {}\n public static List<T> findAll(String query, java.util.Map namedArgs) {}\n public static List<T> findAll(String query, java.util.Map namedArgs, java.util.Map paginateParams) {}\n public static List<T> findAllWhere(java.util.Map query) {}\n public static T find(String query) {}\n public static T find(String query, java.util.Collection args) {}\n public static T find(String query, java.util.Map namedArgs) {}\n public static T find(T example) {}\n public static T findWhere(java.util.Map query) {}\n public static Object withSession(groovy.lang.Closure callable){}\n public static Object withTransaction(groovy.lang.Closure callable){}\n public static Object withNewSession(groovy.lang.Closure callable){}\n public static int executeUpdate(String query) {}\n public static int executeUpdate(String query, java.util.Collection args) {}\n public static int executeUpdate(String query, java.util.Map argMap) {}\n public static List<T> executeQuery(String query) {}\n public static List<T> executeQuery(String query, java.util.Collection positionalParams) {}\n public static List<T> executeQuery(String query, java.util.Collection positionalParams, java.util.Map paginateParams) {}\n public static List<T> executeQuery(String query, java.util.Map namedParams) {}\n public static List<T> executeQuery(String query, java.util.Map namedParams, java.util.Map paginateParams) {}\n}";
    public static final Set<String> NOT_A_PERSISTENT_PROPERTIES = ContainerUtil.newHashSet((Object[])new String[]{"errors", "constraints", "properties", "metaClass", "class"});
    private final PsiClass myDomainClass;
    private final PsiClassType myDomainClassType;
    private final String myQname;
    private volatile Map<String, Pair<PsiType, PsiElement>> myPersistentProperties;
    private Map<String, Pair<PsiType, PsiElement>> myPropertiesWithTransients;
    private volatile Map<String, NamedQueryDescriptor> myNamedQueries;
    private volatile List<PsiMethod> myAddToAndRemoveFromMethods;
    private volatile List<PsiMethod> myGetReferenceIdMethods;
    private final Map<String, Pair<PsiType, PsiElement>> myHasMany;
    private final Map<String, Pair<PsiType, PsiElement>> myHasOne;
    private final Map<String, Pair<PsiType, PsiElement>> myBelongsTo;
    private Set<String> myEmbeddedList;
    private volatile String myGrailsVersion;
    private volatile Boolean myHasGormApi14;

    public DomainDescriptor(PsiClass domainClass) {
        this.myDomainClass = domainClass;
        this.myDomainClassType = PsiTypesUtil.getClassType((PsiClass)domainClass);
        this.myQname = domainClass.getQualifiedName();
        if (domainClass instanceof GrTypeDefinition) {
            this.myHasMany = new HashMap<String, Pair<PsiType, PsiElement>>();
            DomainDescriptor.findAllPropertiesFromField(this.myHasMany, "hasMany", (GrTypeDefinition)domainClass);
            DomainDescriptor.findAllPropertiesFromField(this.myHasMany, "relatesToMany", (GrTypeDefinition)domainClass);
            this.myHasOne = DomainDescriptor.findAllPropertiesFromField("hasOne", (GrTypeDefinition)domainClass);
            this.myBelongsTo = DomainDescriptor.findAllPropertiesFromField("belongsTo", (GrTypeDefinition)domainClass);
        } else {
            this.myHasMany = Collections.emptyMap();
            this.myHasOne = Collections.emptyMap();
            this.myBelongsTo = Collections.emptyMap();
        }
    }

    @NotNull
    public static DomainDescriptor getDescriptor(@NotNull PsiClass domainClass) {
        if (domainClass == null) {
            DomainDescriptor.$$$reportNull$$$0(0);
        }
        PsiClass aClass = PsiUtil.getOriginalClass((PsiClass)domainClass);
        DomainDescriptor domainDescriptor = (DomainDescriptor)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> CachedValueProvider.Result.create((Object)new DomainDescriptor(aClass), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT}));
        if (domainDescriptor == null) {
            DomainDescriptor.$$$reportNull$$$0(1);
        }
        return domainDescriptor;
    }

    public static Map<String, Pair<PsiType, PsiElement>> getPersistentProperties(@NotNull PsiClass domainClass) {
        if (domainClass == null) {
            DomainDescriptor.$$$reportNull$$$0(2);
        }
        return DomainDescriptor.getDescriptor(domainClass).getPersistentProperties();
    }

    private static void findAllPropertiesFromField(Map<String, Pair<PsiType, PsiElement>> res, @Nullable PsiField field, GrTypeDefinition domainClass) {
        if (!(field instanceof GrField)) {
            return;
        }
        GrExpression initializer = ((GrField)field).getInitializerGroovy();
        if (!(initializer instanceof GrListOrMap) || !((GrListOrMap)initializer).isMap()) {
            return;
        }
        GrListOrMap lom = (GrListOrMap)initializer;
        for (GrNamedArgument argument : lom.getNamedArguments()) {
            GrArgumentLabel label = argument.getLabel();
            GrExpression expr = argument.getExpression();
            if (label == null || !(expr instanceof GrReferenceExpression)) continue;
            GrReferenceExpression ref = (GrReferenceExpression)expr;
            String name = label.getName();
            if (!GroovyNamesUtil.isIdentifier((String)name)) continue;
            res.put(name, (Pair<PsiType, PsiElement>)new Pair((Object)new GrClassReferenceType((GrReferenceElement)ref), (Object)DomainDescriptor.resolveLabel(label, name, domainClass)));
        }
    }

    private static void findAllPropertiesFromField(Map<String, Pair<PsiType, PsiElement>> res, String fieldName, GrTypeDefinition domainClass) {
        HashSet<GrTypeDefinition> visited = new HashSet<GrTypeDefinition>();
        GrTypeDefinition aClass = domainClass;
        while (aClass instanceof GrTypeDefinition && visited.add(aClass)) {
            PsiField field = aClass.findCodeFieldByName(fieldName, false);
            DomainDescriptor.findAllPropertiesFromField(res, field, domainClass);
            aClass = aClass.getSuperClass();
        }
    }

    private static Map<String, Pair<PsiType, PsiElement>> findAllPropertiesFromField(String fieldName, GrTypeDefinition domainClass) {
        HashMap<String, Pair<PsiType, PsiElement>> res = new HashMap<String, Pair<PsiType, PsiElement>>();
        DomainDescriptor.findAllPropertiesFromField(res, fieldName, domainClass);
        return res;
    }

    @Nullable
    private static PsiElement resolveLabel(GrArgumentLabel label, String name, GrTypeDefinition domainClass) {
        for (PsiMethod method : domainClass.findCodeMethodsByName(GroovyPropertyUtils.getGetterNameNonBoolean((String)name), true)) {
            if (method.getParameterList().getParametersCount() != 0) continue;
            return method;
        }
        return label;
    }

    private static void parseFieldNameList(Collection<String> res, @Nullable PsiField field) {
        if (!(field instanceof GrField)) {
            return;
        }
        GrExpression initializer = ((GrField)field).getInitializerGroovy();
        if (!(initializer instanceof GrListOrMap)) {
            return;
        }
        GrListOrMap lom = (GrListOrMap)initializer;
        if (lom.isMap()) {
            return;
        }
        for (GrExpression argument : lom.getInitializers()) {
            Object value;
            if (!(argument instanceof GrLiteralImpl) || !((value = ((GrLiteralImpl)argument).getValue()) instanceof String)) continue;
            res.add((String)value);
        }
    }

    private static void collectAllEmbeddedPropertyNames(Collection<String> res, PsiClass domainClass) {
        HashSet<PsiClass> visited = new HashSet<PsiClass>();
        PsiClass aClass = domainClass;
        while (aClass instanceof GrTypeDefinition && visited.add(aClass)) {
            PsiField field = ((GrTypeDefinition)aClass).findCodeFieldByName("embedded", false);
            DomainDescriptor.parseFieldNameList(res, field);
            aClass = aClass.getSuperClass();
        }
    }

    public Set<String> getEmbeddedPropertyNames() {
        Set<String> res = this.myEmbeddedList;
        if (res == null) {
            res = new HashSet<String>();
            DomainDescriptor.collectAllEmbeddedPropertyNames(res, this.myDomainClass);
            this.myEmbeddedList = res;
        }
        return res;
    }

    @NotNull
    public String getGrailsVersion() {
        String res = this.myGrailsVersion;
        if (res == null) {
            GrailsStructure instance = GrailsStructure.getInstance((PsiElement)this.myDomainClass);
            if (instance != null) {
                res = instance.getGrailsVersion();
            }
            if (res == null) {
                res = "zzz";
            }
            this.myGrailsVersion = res;
        }
        String string = res;
        if (string == null) {
            DomainDescriptor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static boolean isDomainClassType(@Nullable PsiType type) {
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type);
        return GormUtils.isGormBean(aClass);
    }

    public List<PsiMethod> getAddToAndRemoveFromMethods() {
        List<Object> res = this.myAddToAndRemoveFromMethods;
        if (res == null) {
            if (this.myHasMany.isEmpty()) {
                res = Collections.emptyList();
            } else {
                res = new ArrayList<PsiMethod>(this.myHasMany.size() * 3);
                PsiManager manager = this.myDomainClass.getManager();
                for (Map.Entry<String, Pair<PsiType, PsiElement>> entry : this.myHasMany.entrySet()) {
                    PsiElement element = (PsiElement)entry.getValue().second;
                    PsiType fieldType = (PsiType)entry.getValue().first;
                    String propertyName = StringUtil.capitalizeWithJavaBeanConvention((String)entry.getKey());
                    String addToName = "addTo" + propertyName;
                    GrLightMethodBuilder addInstance = new GrLightMethodBuilder(manager, addToName);
                    addInstance.addModifier(1);
                    addInstance.setReturnType((PsiType)this.myDomainClassType);
                    addInstance.addParameter("instance", fieldType, false);
                    addInstance.setNavigationElement(element);
                    res.add((PsiMethod)addInstance);
                    if (DomainDescriptor.isDomainClassType(fieldType)) {
                        GrLightMethodBuilder addMap = new GrLightMethodBuilder(manager, addToName);
                        addMap.setMethodKind(ADD_TO_METHOD_MARKER);
                        addMap.setModifiers(1);
                        addMap.setReturnType((PsiType)this.myDomainClassType);
                        addMap.addParameter("args", "java.util.Map", false);
                        addMap.setNavigationElement(element);
                        res.add(addMap);
                    }
                    GrLightMethodBuilder remove = new GrLightMethodBuilder(manager, "removeFrom" + propertyName);
                    remove.addModifier(1);
                    remove.setReturnType((PsiType)PsiType.VOID);
                    remove.addParameter("instance", fieldType, false);
                    remove.setNavigationElement(element);
                    res.add(remove);
                }
            }
            this.myAddToAndRemoveFromMethods = res;
        }
        return res;
    }

    public List<PsiMethod> getGetReferenceIdMethods() {
        List<Object> res = this.myGetReferenceIdMethods;
        if (res == null) {
            for (Map.Entry<String, Pair<PsiType, PsiElement>> entry : this.getPersistentProperties().entrySet()) {
                if (!GormUtils.isGormBean(PsiTypesUtil.getPsiClass((PsiType)((PsiType)entry.getValue().first)))) continue;
                String getterName = GroovyPropertyUtils.getGetterNameNonBoolean((String)(entry.getKey() + "Id"));
                GrLightMethodBuilder m = new GrLightMethodBuilder(this.myDomainClass.getManager(), getterName);
                m.setModifiers(1);
                m.setReturnType("java.lang.Long", this.myDomainClass.getResolveScope());
                if (res == null) {
                    res = new ArrayList();
                }
                res.add((PsiMethod)m);
            }
            if (res == null) {
                res = Collections.emptyList();
            }
            this.myGetReferenceIdMethods = res;
        }
        return res;
    }

    public Map<String, Pair<PsiType, PsiElement>> getHasMany() {
        return this.myHasMany;
    }

    public Map<String, Pair<PsiType, PsiElement>> getHasOne() {
        return this.myHasOne;
    }

    public Map<String, Pair<PsiType, PsiElement>> getBelongsTo() {
        return this.myBelongsTo;
    }

    private boolean processWithTypeReplace(DynamicMemberUtils.ClassMemberHolder classMemberHolder, PsiScopeProcessor processor, PsiMethod[] methods, ResolveState state) {
        if (methods.length == 0) {
            return true;
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY.putAll((PsiClass)classMemberHolder.getParsedClass(), new PsiType[]{this.myDomainClassType});
        for (PsiMethod method : methods) {
            GrLightMethodBuilder methodBuilder = GrailsPsiUtil.substitute(method, substitutor);
            methodBuilder.setData((Object)this.myDomainClass);
            methodBuilder.setMethodKind(DOMAIN_DYNAMIC_METHOD);
            if (processor.execute((PsiElement)methodBuilder, state)) continue;
            return false;
        }
        return true;
    }

    public boolean processDynamicMethods(PsiScopeProcessor processor, @Nullable String nameHint, ResolveState state) {
        DynamicMemberUtils.ClassMemberHolder members;
        Project project = this.myDomainClass.getProject();
        if (!this.hasGormApi14() && !this.processWithTypeReplace(members = DynamicMemberUtils.getMembers((Project)project, (String)OLD_METHODS), processor, members.getDynamicMethods(nameHint), state)) {
            return false;
        }
        String version = this.getGrailsVersion();
        for (PsiMethod method : DynamicMemberUtils.getMembers((Project)project, (String)METACLASS_METHODS).getDynamicMethods(nameHint)) {
            if (!DynamicMemberUtils.checkVersion((PsiMethod)method, (String)version) || processor.execute((PsiElement)method, state)) continue;
            return false;
        }
        if (nameHint == null || nameHint.startsWith("addTo") || nameHint.startsWith("removeFrom")) {
            for (PsiMethod method : this.getAddToAndRemoveFromMethods()) {
                if (nameHint != null && !nameHint.equals(method.getName()) || processor.execute((PsiElement)method, state)) continue;
                return false;
            }
        }
        if (nameHint == null || nameHint.endsWith("Id") || nameHint.length() > 2) {
            for (PsiMethod method : this.getGetReferenceIdMethods()) {
                if (nameHint != null && !nameHint.equals(method.getName()) || processor.execute((PsiElement)method, state)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasGormApi14() {
        Boolean res = this.myHasGormApi14;
        if (res == null) {
            PsiClass api14Class = JavaPsiFacade.getInstance((Project)this.myDomainClass.getProject()).findClass(GORM_INSTANCE_API_CLASS, this.myDomainClass.getResolveScope());
            this.myHasGormApi14 = res = Boolean.valueOf(api14Class != null);
        }
        return res;
    }

    public boolean processStaticMethods(PsiScopeProcessor processor, @Nullable String nameHint, ResolveState state) {
        DynamicMemberUtils.ClassMemberHolder members;
        Project project = this.myDomainClass.getProject();
        if (!this.hasGormApi14() && !this.processWithTypeReplace(members = DynamicMemberUtils.getMembers((Project)project, (String)OLD_METHODS), processor, members.getStaticMethods(nameHint), state)) {
            return false;
        }
        String version = this.getGrailsVersion();
        for (PsiMethod method : DynamicMemberUtils.getMembers((Project)project, (String)METACLASS_METHODS).getDynamicMethods(nameHint)) {
            if (!DynamicMemberUtils.checkVersion((PsiMethod)method, (String)version) || processor.execute((PsiElement)method, state)) continue;
            return false;
        }
        return true;
    }

    public Map<String, NamedQueryDescriptor> getNamedQueries() {
        Map<String, NamedQueryDescriptor> res = this.myNamedQueries;
        if (res == null) {
            PsiField namedQueryField = this.myDomainClass.findFieldByName("namedQueries", false);
            if (namedQueryField instanceof GrField) {
                res = new HashMap<String, NamedQueryDescriptor>();
                GrExpression initializer = ((GrField)namedQueryField).getInitializerGroovy();
                if (initializer instanceof GrClosableBlock) {
                    for (PsiElement e = initializer.getFirstChild(); e != null; e = e.getNextSibling()) {
                        PsiType type;
                        GrExpression invokedExpr;
                        GrMethodCall method;
                        GrClosableBlock closure;
                        if (!(e instanceof GrMethodCall) || (closure = GrailsUtils.getClosureArgument(method = (GrMethodCall)e)) == null || !((invokedExpr = method.getInvokedExpression()) instanceof GrReferenceExpression) || ((GrReferenceExpression)invokedExpr).isQualified() || !((type = closure.getType()) instanceof GrClosureType)) continue;
                        String name = ((GrReferenceExpression)invokedExpr).getReferenceName();
                        res.put(name, new NamedQueryDescriptor(this, name, method, closure));
                    }
                }
            } else {
                res = Collections.emptyMap();
            }
            this.myNamedQueries = res;
        }
        return res;
    }

    public PsiClass getDomainClass() {
        return this.myDomainClass;
    }

    public boolean isToManyRelation(String propertyName) {
        return this.myHasMany.containsKey(propertyName);
    }

    public Map<String, Pair<PsiType, PsiElement>> getPersistentProperties() {
        Map<String, Pair<PsiType, PsiElement>> result2 = this.myPersistentProperties;
        if (result2 == null) {
            result2 = new HashMap<String, Pair<PsiType, PsiElement>>();
            for (PsiMethod method : this.myDomainClass.getAllMethods()) {
                String propertyName;
                if (!GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)method) || method.hasModifierProperty("static") || NOT_A_PERSISTENT_PROPERTIES.contains(propertyName = GroovyPropertyUtils.getPropertyNameByGetter((PsiMethod)method)) || result2.containsKey(propertyName)) continue;
                PsiMethod element = method;
                if (element instanceof GrAccessorMethod) {
                    GrField field = ((GrAccessorMethod)element).getProperty();
                    if (!(field instanceof LightElement) && field.getTypeElementGroovy() == null) continue;
                    element = field;
                }
                PsiType returnType = method.getReturnType();
                assert (returnType != null);
                if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.Collection")) {
                    Pair<PsiType, PsiElement> pair = this.myHasMany.get(propertyName);
                    if (pair == null) continue;
                    if (com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)returnType, (boolean)false) == null) {
                        PsiClass collectionClass = ((PsiClassType)returnType).resolve();
                        returnType = new PsiImmediateClassType(collectionClass, PsiSubstitutor.EMPTY.putAll(collectionClass, new PsiType[]{(PsiType)pair.first}));
                    }
                }
                result2.put(propertyName, (Pair<PsiType, PsiElement>)Pair.create((Object)returnType, (Object)element));
            }
            this.myPropertiesWithTransients = (Map)((HashMap)result2).clone();
            this.removeTransientsProperties(result2, "transients");
            this.removeTransientsProperties(result2, "evanescent");
            this.myPersistentProperties = result2;
        }
        return result2;
    }

    @NotNull
    public Map<String, Pair<PsiType, PsiElement>> getPropertiesWithTransients() {
        this.getPersistentProperties();
        Map<String, Pair<PsiType, PsiElement>> map2 = this.myPropertiesWithTransients;
        if (map2 == null) {
            DomainDescriptor.$$$reportNull$$$0(4);
        }
        return map2;
    }

    private void removeTransientsProperties(Map<String, Pair<PsiType, PsiElement>> result2, String transientFieldName) {
        GrExpression initializer;
        PsiField transientList = this.myDomainClass.findFieldByName(transientFieldName, false);
        if (transientList instanceof GrField && transientList.hasModifierProperty("static") && (initializer = ((GrField)transientList).getInitializerGroovy()) instanceof GrListOrMap && !((GrListOrMap)initializer).isMap()) {
            GrailsPsiUtil.removeValuesFromList(result2.keySet(), (GrListOrMap)initializer);
        }
    }

    public PsiClassType getDomainClassType() {
        return this.myDomainClassType;
    }

    public String getQname() {
        return this.myQname;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/references/domain/DomainDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/references/domain/DomainDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrailsVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesWithTransients";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPersistentProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

