/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsCommandLineExecutor;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.groovy.mvc.ConsoleProcessDescriptor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public final class GrailsCommandExecutorUtil {
    @Nullable
    public static ConsoleProcessDescriptor execute(@NotNull GrailsApplication application, @NotNull MvcCommand command) {
        if (application == null) {
            GrailsCommandExecutorUtil.$$$reportNull$$$0(0);
        }
        if (command == null) {
            GrailsCommandExecutorUtil.$$$reportNull$$$0(1);
        }
        return GrailsCommandExecutorUtil.execute(application, command, null);
    }

    @Nullable
    public static ConsoleProcessDescriptor execute(@NotNull GrailsApplication application, @NotNull MvcCommand command, @Nullable Runnable onDone) {
        if (application == null) {
            GrailsCommandExecutorUtil.$$$reportNull$$$0(2);
        }
        if (command == null) {
            GrailsCommandExecutorUtil.$$$reportNull$$$0(3);
        }
        return GrailsCommandExecutorUtil.execute(application, command, onDone, true, new String[0]);
    }

    @Nullable
    public static ConsoleProcessDescriptor execute(@NotNull GrailsApplication application, @NotNull MvcCommand command, @Nullable Runnable onDone, boolean close, String ... input) {
        if (application == null) {
            GrailsCommandExecutorUtil.$$$reportNull$$$0(4);
        }
        if (command == null) {
            GrailsCommandExecutorUtil.$$$reportNull$$$0(5);
        }
        try {
            GrailsCommandExecutor executor = GrailsCommandExecutor.getGrailsExecutor(application);
            if (executor == null) {
                return null;
            }
            return executor.execute(application, command, onDone, close, input);
        }
        catch (ExecutionException e) {
            GrailsConsole.getInstance(application.getProject());
            GrailsConsole.NOTIFICATION_GROUP.createNotification(e.getMessage(), NotificationType.ERROR);
            return null;
        }
    }

    public static void executeInModal(@NotNull GrailsApplication application, @NotNull MvcCommand command, @NotNull String title, @Nullable Runnable onDone, boolean close) {
        if (application == null) {
            GrailsCommandExecutorUtil.$$$reportNull$$$0(6);
        }
        if (command == null) {
            GrailsCommandExecutorUtil.$$$reportNull$$$0(7);
        }
        if (title == null) {
            GrailsCommandExecutorUtil.$$$reportNull$$$0(8);
        }
        assert (!GrailsConsole.getInstance(application.getProject()).isExecuting());
        Ref processIndicatorRef = new Ref();
        Runnable run = onDone == null ? null : () -> {
            ProgressIndicator indicator = (ProgressIndicator)processIndicatorRef.get();
            if (indicator != null && indicator.isCanceled()) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(onDone);
        };
        try {
            GeneralCommandLine commandLine = GrailsCommandExecutorUtil.createCommandLine(application, command);
            ConsoleProcessDescriptor descriptor = GrailsConsole.executeProcess(application.getProject(), commandLine, run, close, new String[0]);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                if (title == null) {
                    GrailsCommandExecutorUtil.$$$reportNull$$$0(12);
                }
                final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                processIndicatorRef.set((Object)progressIndicator);
                progressIndicator.setText(title);
                descriptor.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        progressIndicator.setText2(event.getText());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil$1";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }).waitWith(progressIndicator);
            }, title, true, application.getProject());
        }
        catch (ExecutionException e) {
            GrailsConsole.getInstance(application.getProject());
            GrailsConsole.NOTIFICATION_GROUP.createNotification(e.getMessage(), NotificationType.ERROR);
        }
    }

    @NotNull
    public static GeneralCommandLine createCommandLine(@NotNull GrailsApplication application, @NotNull MvcCommand command) throws ExecutionException {
        GrailsCommandExecutor executor;
        if (application == null) {
            GrailsCommandExecutorUtil.$$$reportNull$$$0(9);
        }
        if (command == null) {
            GrailsCommandExecutorUtil.$$$reportNull$$$0(10);
        }
        if ((executor = GrailsCommandExecutor.getGrailsExecutor(application)) instanceof GrailsCommandLineExecutor) {
            GeneralCommandLine generalCommandLine = ((GrailsCommandLineExecutor)executor).createCommandLine(application, command);
            if (generalCommandLine == null) {
                GrailsCommandExecutorUtil.$$$reportNull$$$0(11);
            }
            return generalCommandLine;
        }
        throw new ExecutionException("Cannot create command line for '" + command + "' in " + application.getRoot());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/runner/GrailsCommandExecutorUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeInModal";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeInModal$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

