/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.SetupKt;
import org.jetbrains.plugins.grails.runner.impl.Grails3TestCommandLineState;
import org.jetbrains.plugins.grails.runner.impl.GrailsCommandLineState;
import org.jetbrains.plugins.grails.runner.impl.GrailsRunAppCommandLineState;
import org.jetbrains.plugins.grails.runner.impl.GrailsTestCommandLineState;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.ConsoleProcessDescriptor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public abstract class GrailsCommandLineExecutor
extends GrailsCommandExecutor {
    private static final String RUN_APP_PATTERN = "\\s*(-D[^\\s]+\\s+)*run-app(\\s.*)?";
    private static final String TEST_APP_PATTERN = "\\s*(-D[^\\s]+\\s+)*test-app(\\s.*)?";

    @Nullable
    private RunProfileState getSpecialState(@NotNull GrailsRunConfiguration configuration, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        String programParameters;
        if (configuration == null) {
            GrailsCommandLineExecutor.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            GrailsCommandLineExecutor.$$$reportNull$$$0(1);
        }
        if ((programParameters = configuration.getProgramParameters()) == null) {
            return null;
        }
        Version version = configuration.getGrailsApplication().getGrailsVersion();
        if (programParameters.matches(TEST_APP_PATTERN)) {
            if (version.compareTo(Version.GRAILS_3_0) >= 0) {
                if (SetupKt.getPathToGradleInitScript() != null) {
                    return new Grails3TestCommandLineState(environment, configuration, this);
                }
            } else if (version.compareTo(Version.GRAILS_1_2) >= 0) {
                return new GrailsTestCommandLineState(environment, configuration, this);
            }
        } else if (programParameters.matches(RUN_APP_PATTERN)) {
            return new GrailsRunAppCommandLineState(environment, configuration, this);
        }
        return null;
    }

    @Override
    @Nullable
    public RunProfileState getState(@NotNull GrailsRunConfiguration configuration, @NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        RunProfileState state;
        if (configuration == null) {
            GrailsCommandLineExecutor.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            GrailsCommandLineExecutor.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            GrailsCommandLineExecutor.$$$reportNull$$$0(4);
        }
        return (state = this.getSpecialState(configuration, environment)) == null ? new GrailsCommandLineState(environment, configuration, this) : state;
    }

    @Override
    @Nullable
    public ConsoleProcessDescriptor execute(@NotNull GrailsApplication application, @NotNull MvcCommand command, @Nullable Runnable onDone, boolean close, String ... input) throws ExecutionException {
        if (application == null) {
            GrailsCommandLineExecutor.$$$reportNull$$$0(5);
        }
        if (command == null) {
            GrailsCommandLineExecutor.$$$reportNull$$$0(6);
        }
        Project project = application.getProject();
        return GrailsConsole.getInstance(project).executeProcess(this.createCommandLine(application, command), onDone, true, close, input);
    }

    public GeneralCommandLine createCommandLine(@NotNull GrailsApplication application, @NotNull MvcCommand command) throws ExecutionException {
        if (application == null) {
            GrailsCommandLineExecutor.$$$reportNull$$$0(7);
        }
        if (command == null) {
            GrailsCommandLineExecutor.$$$reportNull$$$0(8);
        }
        JavaParameters params = this.createJavaParameters(application, command);
        params.setUseDynamicClasspath(application.getProject());
        return params.toCommandLine();
    }

    @NotNull
    public abstract JavaParameters createJavaParameters(@NotNull GrailsApplication var1, @NotNull MvcCommand var2) throws ExecutionException;

    public void addListener(@NotNull JavaParameters params, @NotNull String listener) {
        String listeners;
        if (params == null) {
            GrailsCommandLineExecutor.$$$reportNull$$$0(9);
        }
        if (listener == null) {
            GrailsCommandLineExecutor.$$$reportNull$$$0(10);
        }
        listeners = (listeners = params.getVMParametersList().getPropertyValue("grails.build.listeners")) != null ? (listeners.startsWith("\"") && listeners.endsWith("\"") ? "\"" + listeners.substring(1, listeners.length() - 2) + "," + listener + "\"" : "\"" + listeners + "," + listener + "\"") : listener;
        params.getVMParametersList().replaceOrAppend("grails.build.listeners", "-Dgrails.build.listeners=" + listeners);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/runner/GrailsCommandLineExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpecialState";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createCommandLine";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

