/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.sdk;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.sdk.GrailsSDK;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsSDKListener;
import org.jetbrains.plugins.grails.util.version.VersionImpl;

@State(name="GrailsSDKManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GrailsSDKManager
implements PersistentStateComponent<StateHolder> {
    private final Map<String, String> myGrailsSDKs = ContainerUtil.newHashMap();

    @NotNull
    public static GrailsSDKManager getInstance(@NotNull Project project) {
        if (project == null) {
            GrailsSDKManager.$$$reportNull$$$0(0);
        }
        GrailsSDKManager grailsSDKManager = (GrailsSDKManager)ServiceManager.getService((Project)project, GrailsSDKManager.class);
        if (grailsSDKManager == null) {
            GrailsSDKManager.$$$reportNull$$$0(1);
        }
        return grailsSDKManager;
    }

    @Nullable
    public static String getGrailsSdkPath(@Nullable GrailsApplication application) {
        if (application == null) {
            return null;
        }
        String rootPath = application.getRoot().getCanonicalPath();
        return GrailsSDKManager.getInstance((Project)application.getProject()).myGrailsSDKs.get(rootPath);
    }

    @Nullable
    public static GrailsSDK getGrailsSdk(@NotNull GrailsApplication application) {
        String sdkPath;
        if (application == null) {
            GrailsSDKManager.$$$reportNull$$$0(2);
        }
        if ((sdkPath = GrailsSDKManager.getGrailsSdkPath(application)) == null) {
            return null;
        }
        String version = GrailsConfigUtils.getInstance().getSDKVersion(sdkPath);
        if (version == "undefined") {
            return null;
        }
        return new GrailsSDK(sdkPath, new VersionImpl(version));
    }

    public static void setGrailsSDK(@NotNull GrailsApplication application, @Nullable String path) {
        String oldPath;
        String rootPath;
        if (application == null) {
            GrailsSDKManager.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            path = null;
        }
        if ((rootPath = application.getRoot().getCanonicalPath()) != null && !Comparing.equal((String)path, (String)(oldPath = GrailsSDKManager.getInstance(application.getProject()).setGrailsSDK(rootPath, path)))) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (application == null) {
                    GrailsSDKManager.$$$reportNull$$$0(5);
                }
                ((GrailsSDKListener)application.getProject().getMessageBus().syncPublisher(GrailsSDKListener.TOPIC)).sdkChanged(application);
            });
        }
    }

    @Nullable
    public String setGrailsSDK(@NotNull String rootPath, @Nullable String path) {
        if (rootPath == null) {
            GrailsSDKManager.$$$reportNull$$$0(4);
        }
        PropertiesComponent.getInstance().setValue("grails.last.selected.sdk.home", path);
        return this.myGrailsSDKs.put(rootPath, path);
    }

    @Nullable
    public synchronized StateHolder getState() {
        StateHolder holder = new StateHolder();
        holder.grailsSDKs.putAll(this.myGrailsSDKs);
        return holder;
    }

    public void loadState(StateHolder state) {
        this.myGrailsSDKs.clear();
        this.myGrailsSDKs.putAll(state.grailsSDKs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/sdk/GrailsSDKManager";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/sdk/GrailsSDKManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getGrailsSdk";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setGrailsSDK";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setGrailsSDK$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StateHolder {
        public Map<String, String> grailsSDKs = new THashMap();
    }
}

