/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.navigation;

import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.web.mvc.SpringControllerClassInfo;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringMvcViewGotoRelatedProvider
extends GotoRelatedProvider {
    private static final String GROUP_NAME = "Spring MVC";

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        PsiFile psiFile;
        if (context == null) {
            SpringMvcViewGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        if ((psiFile = context.getContainingFile()) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringMvcViewGotoRelatedProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (psiFile instanceof PsiClassOwner && !BaseJspUtil.isInJspFile((PsiFile)psiFile)) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringMvcViewGotoRelatedProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        SpringMVCModel model = SpringMVCModelService.getInstance().getModel(context);
        if (model == null) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringMvcViewGotoRelatedProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        List resolvers = model.getViewResolvers();
        if (resolvers.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringMvcViewGotoRelatedProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        SmartList items = new SmartList();
        for (SpringBeanPointer pointer : model.getControllers()) {
            PsiClass beanClass = pointer.getBeanClass();
            if (beanClass == null) continue;
            SpringControllerClassInfo info = SpringControllerClassInfo.getInfo(beanClass);
            MultiMap<String, PsiMethod> views = info.getViews(null);
            for (String view : views.keySet()) {
                for (ViewResolver resolver : resolvers) {
                    PsiElement psiElement = resolver.resolveFinalView(context, view, model);
                    if (psiElement == null || !Comparing.equal((Object)psiFile.getVirtualFile(), (Object)psiElement.getContainingFile().getVirtualFile())) continue;
                    for (PsiMethod method : views.get((Object)view)) {
                        items.add(new GotoRelatedItem((PsiElement)method, GROUP_NAME));
                    }
                }
            }
        }
        SmartList smartList = items;
        if (smartList == null) {
            SpringMvcViewGotoRelatedProvider.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/navigation/SpringMvcViewGotoRelatedProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/navigation/SpringMvcViewGotoRelatedProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

