/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanNameViewResolverFactory
extends ViewResolverFactory {
    public String getBeanClass() {
        return "org.springframework.web.servlet.view.BeanNameViewResolver";
    }

    @NotNull
    public Set<ViewResolver> doCreate(@Nullable CommonSpringBean bean, SpringModel model) {
        assert (bean != null);
        BeanNameViewResolver beanNameViewResolver = new BeanNameViewResolver(bean.getBeanName() + "[" + bean.getContainingFile().getName() + "]");
        Set<ViewResolver> set = Collections.singleton(beanNameViewResolver);
        if (set == null) {
            BeanNameViewResolverFactory.$$$reportNull$$$0(0);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/BeanNameViewResolverFactory", "doCreate"));
    }

    public static class BeanNameViewResolver
    extends ViewResolver {
        @NotNull
        private final String myID;

        public BeanNameViewResolver(@NotNull String ID) {
            if (ID == null) {
                BeanNameViewResolver.$$$reportNull$$$0(0);
            }
            this.myID = ID;
        }

        @NotNull
        public String getID() {
            String string = this.myID;
            if (string == null) {
                BeanNameViewResolver.$$$reportNull$$$0(1);
            }
            return string;
        }

        public PsiElement resolveView(@NotNull PsiElement context, String viewName, SpringMVCModel springMVCModel) {
            if (context == null) {
                BeanNameViewResolver.$$$reportNull$$$0(2);
            }
            if (StringUtil.isEmpty((String)viewName)) {
                return null;
            }
            Collection<SpringModel> models = this.getModels(springMVCModel);
            for (SpringModel model : models) {
                SpringBeanPointer beanPointer = SpringModelSearchers.findBean((CommonSpringModel)model, (String)viewName);
                if (beanPointer == null) continue;
                return beanPointer.getPsiElement();
            }
            return null;
        }

        @Nullable
        public PsiElement resolveFinalView(@NotNull PsiElement context, String viewName, SpringMVCModel springMVCModel) {
            if (context == null) {
                BeanNameViewResolver.$$$reportNull$$$0(3);
            }
            if (StringUtil.isEmpty((String)viewName)) {
                return null;
            }
            Collection<SpringModel> models = this.getModels(springMVCModel);
            for (SpringModel model : models) {
                CommonSpringBean bean;
                SpringBeanPointer beanPointer = SpringModelSearchers.findBean((CommonSpringModel)model, (String)viewName);
                if (beanPointer == null || !((bean = beanPointer.getSpringBean()) instanceof SpringBean)) continue;
                String url = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"url");
                if (url == null) {
                    return null;
                }
                WebDirectoryElement webDirectoryElement = springMVCModel.findWebDirectoryElement(url);
                return webDirectoryElement != null ? webDirectoryElement.getOriginalFile() : null;
            }
            return null;
        }

        public List<LookupElement> getAllViews(@NotNull PsiElement context, SpringMVCModel springMVCModel) {
            SpringModel springModel;
            if (context == null) {
                BeanNameViewResolver.$$$reportNull$$$0(4);
            }
            if ((springModel = (SpringModel)ContainerUtil.getFirstItem((Collection)springMVCModel.getAllModels())) == null) {
                return Collections.emptyList();
            }
            PsiClass servletView = SpringCommonUtils.findLibraryClass((Module)springModel.getModule(), (String)"org.springframework.web.servlet.View");
            if (servletView == null) {
                return Collections.emptyList();
            }
            SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)servletView).withInheritors();
            ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
            Collection<SpringModel> models = this.getModels(springMVCModel);
            for (SpringModel model : models) {
                List beanPointers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
                variants.addAll(ContainerUtil.mapNotNull((Collection)beanPointers, SpringConverterUtil::createCompletionVariant));
            }
            return variants;
        }

        public String bindToElement(PsiElement element) {
            return null;
        }

        @NotNull
        public String handleElementRename(String newElementName) {
            String string = newElementName;
            if (string == null) {
                BeanNameViewResolver.$$$reportNull$$$0(5);
            }
            return string;
        }

        protected Collection<SpringModel> getModels(SpringMVCModel context) {
            return context.getAllModels();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ID";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/web/mvc/views/BeanNameViewResolverFactory$BeanNameViewResolver";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/web/mvc/views/BeanNameViewResolverFactory$BeanNameViewResolver";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getID";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "handleElementRename";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveView";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveFinalView";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllViews";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

