/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.NotNexusIndexer;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.server.MavenIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

class BintrayIndexer
implements NotNexusIndexer {
    private final String myUrlTemplate;

    public BintrayIndexer(@NotNull String subject, @Nullable String repo) {
        if (subject == null) {
            BintrayIndexer.$$$reportNull$$$0(0);
        }
        this.myUrlTemplate = "https://bintray.com/api/v1/search/packages/maven?q=*&subject=" + subject + (repo != null ? "&repo=" + repo : "");
    }

    @Override
    public void processArtifacts(MavenProgressIndicator progress, MavenIndicesProcessor processor) throws IOException, MavenServerIndexerException {
        AtomicReference exception = new AtomicReference();
        HttpRequests.request((String)this.myUrlTemplate).accept("application/json").connect(request -> {
            URLConnection urlConnection = request.getConnection();
            int total = urlConnection.getHeaderFieldInt("X-RangeLimit-Total", -1);
            if (total > 0) {
                this.fetchMavenIds(request, processor);
                int endPos = urlConnection.getHeaderFieldInt("X-RangeLimit-EndPos", Integer.MAX_VALUE);
                if (endPos < total) {
                    progress.pushState();
                    progress.setIndeterminate(false);
                    try {
                        int totalIterations = (total - 1) / endPos;
                        int threadsCount = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
                        boolean useThreadPool = threadsCount > 1 && totalIterations >= 10;
                        CountDownLatch cdl = useThreadPool ? new CountDownLatch(threadsCount) : null;
                        AtomicInteger iterationsCounter = new AtomicInteger(0);
                        Runnable task = () -> {
                            try {
                                int i;
                                while ((i = iterationsCounter.incrementAndGet()) <= totalIterations) {
                                    if (progress.isCanceled()) {
                                        break;
                                    }
                                    try {
                                        HttpRequests.request((String)(this.myUrlTemplate + "&start_pos=" + i * endPos)).accept("application/json").connect(r -> {
                                            this.fetchMavenIds(r, processor);
                                            progress.setFraction(1.0 * (double)iterationsCounter.get() / (double)totalIterations);
                                            return null;
                                        });
                                    }
                                    catch (Exception e) {
                                        exception.set(e);
                                        break;
                                    }
                                }
                            }
                            finally {
                                if (useThreadPool) {
                                    cdl.countDown();
                                }
                            }
                        };
                        if (useThreadPool) {
                            ExecutorService executorService = Executors.newFixedThreadPool(threadsCount);
                            for (int i = 0; i < threadsCount; ++i) {
                                executorService.submit(task);
                            }
                            try {
                                cdl.await();
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            for (int i = 0; i < totalIterations; ++i) {
                                task.run();
                            }
                        }
                    }
                    finally {
                        progress.popState();
                    }
                }
            }
            return null;
        });
        Exception e = (Exception)exception.get();
        if (e != null) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof MavenServerIndexerException) {
                throw (MavenServerIndexerException)e;
            }
            throw new MavenServerIndexerException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchMavenIds(HttpRequests.Request request, MavenIndicesProcessor processor) throws IOException {
        try (InputStream in = request.getInputStream();){
            JsonElement element = new JsonParser().parse((Reader)new InputStreamReader(in));
            JsonArray array = element.getAsJsonArray();
            if (array == null) {
                throw new IOException("Unexpected response format, JSON array expected from " + request.getURL());
            }
            ArrayList<MavenId> mavenIds = new ArrayList<MavenId>();
            for (JsonElement el : array) {
                JsonObject jo = el.getAsJsonObject();
                JsonArray systemIds = jo.getAsJsonArray("system_ids");
                JsonArray versions = jo.getAsJsonArray("versions");
                if (systemIds == null || versions == null) continue;
                for (JsonElement systemId : systemIds) {
                    String groupAndArtifactId = systemId.getAsString();
                    List list = StringUtil.split((String)groupAndArtifactId, (String)":");
                    if (list.size() != 2) continue;
                    String groupId = (String)list.get(0);
                    String artifactId = (String)list.get(1);
                    for (JsonElement version : versions) {
                        mavenIds.add(new MavenId(groupId, artifactId, version.getAsString()));
                    }
                }
            }
            BintrayIndexer bintrayIndexer = this;
            synchronized (bintrayIndexer) {
                processor.processArtifacts(mavenIds);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "org/jetbrains/idea/maven/indices/BintrayIndexer", "<init>"));
    }
}

