/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.util.Query;
import com.intellij.ws.inspections.fixes.RemoveElementFix;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class NoResourceMethodsFoundInspection
extends AbstractRestJavaInspection {
    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder problemsHolder, @NotNull Module module) {
        if (module == null) {
            NoResourceMethodsFoundInspection.$$$reportNull$$$0(0);
        }
        if (RSUtils.isRootResourceClass((PsiElement)aClass)) {
            NoResourceMethodsFoundInspection.checkRootResourceClassHasResourceMethods(aClass, problemsHolder);
            NoResourceMethodsFoundInspection.checkConstructors(aClass, problemsHolder);
        }
    }

    @Override
    protected void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (psiMethod == null) {
            NoResourceMethodsFoundInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            NoResourceMethodsFoundInspection.$$$reportNull$$$0(2);
        }
        if (module == null) {
            NoResourceMethodsFoundInspection.$$$reportNull$$$0(3);
        }
    }

    private static void checkRootResourceClassHasResourceMethods(PsiClass c, ProblemsHolder problemsHolder) {
        PsiMethod[] methods;
        PsiAnnotation anno = AnnotationUtil.findAnnotation((PsiModifierListOwner)c, (String[])new String[]{"javax.ws.rs.Path"});
        if (anno == null) {
            return;
        }
        for (PsiMethod method : methods = c.getMethods()) {
            if (!RSUtils.isResourceMethod(method)) continue;
            return;
        }
        Query query = DefinitionsScopedSearch.search((PsiElement)c);
        for (PsiElement element : query) {
            if (!(element instanceof PsiClass)) continue;
            PsiClass psiClass = (PsiClass)element;
            for (PsiMethod method : psiClass.getMethods()) {
                if (!RSUtils.isResourceMethod(method)) continue;
                return;
            }
        }
        problemsHolder.registerProblem((PsiElement)anno, RSBundle.message("webservices.inspections.no.resource.methods.found.problem", c.getQualifiedName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveElementFix((PsiElement)anno, RSBundle.message("webservices.inspections.remove.annotation.fix.name", "@Path"))});
    }

    private static void checkConstructors(PsiClass c, ProblemsHolder problemsHolder) {
        PsiMethod[] constructors = c.getConstructors();
        if (constructors.length == 0) {
            return;
        }
        ArrayList<PsiMethod> publicConstructors = new ArrayList<PsiMethod>();
        for (PsiMethod constructor : constructors) {
            if (!NoResourceMethodsFoundInspection.isPublic(constructor)) continue;
            publicConstructors.add(constructor);
        }
        if (publicConstructors.size() == 0) {
            ProblemHighlightType type = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            problemsHolder.registerProblem((PsiElement)c.getNameIdentifier(), RSBundle.message("webservices.inspections.no.public.constructor.found.in.root.resource.class.problem", c.getQualifiedName()), type, new LocalQuickFix[0]);
        }
    }

    public static boolean isPublic(PsiMethod psiMethod) {
        return psiMethod.hasModifierProperty("public");
    }

    @NotNull
    public String getDisplayName() {
        String string = RSBundle.message("webservices.inspections.no.resource.methods.found.display.name", new Object[0]);
        if (string == null) {
            NoResourceMethodsFoundInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = RSBundle.message("webservices.inspections.no.resource.methods.found.short.name", new Object[0]);
        if (string == null) {
            NoResourceMethodsFoundInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/inspections/NoResourceMethodsFoundInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/inspections/NoResourceMethodsFoundInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

