/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.ws.inspections.fixes.RemoveElementFix;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import com.intellij.ws.rest.utils.RSUtils;
import org.jetbrains.annotations.NotNull;

public class UnreachableResourceMethodInspection
extends AbstractRestJavaInspection {
    @Override
    protected void checkMethod(@NotNull PsiMethod method, @NotNull ProblemsHolder problemsHolder, @NotNull Module module) {
        PsiClass c;
        if (method == null) {
            UnreachableResourceMethodInspection.$$$reportNull$$$0(0);
        }
        if (problemsHolder == null) {
            UnreachableResourceMethodInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            UnreachableResourceMethodInspection.$$$reportNull$$$0(2);
        }
        if ((c = method.getContainingClass()) == null) {
            return;
        }
        if (!RSUtils.isResourceMethod(method) || RSUtils.isResourceClass(c) || !RSUtils.isNonAbstractAndPublicClass(c) || RSUtils.findInheritorClassAnnotatedAs("javax.ws.rs.Path", c) != null) {
            return;
        }
        UnreachableResourceMethodInspection.checkAnnotationPresence("javax.ws.rs.Path", "Path", method, problemsHolder);
        UnreachableResourceMethodInspection.checkAnnotationPresence("javax.ws.rs.GET", "GET", method, problemsHolder);
        UnreachableResourceMethodInspection.checkAnnotationPresence("javax.ws.rs.POST", "POST", method, problemsHolder);
        UnreachableResourceMethodInspection.checkAnnotationPresence("javax.ws.rs.PUT", "PUT", method, problemsHolder);
        UnreachableResourceMethodInspection.checkAnnotationPresence("javax.ws.rs.DELETE", "DELETE", method, problemsHolder);
        UnreachableResourceMethodInspection.checkAnnotationPresence("javax.ws.rs.HEAD", "HEAD", method, problemsHolder);
    }

    private static void checkAnnotationPresence(@NotNull String annotationFQN, @NotNull String annotationShortName, @NotNull PsiMethod method, ProblemsHolder problemsHolder) {
        PsiAnnotation annotation;
        if (annotationFQN == null) {
            UnreachableResourceMethodInspection.$$$reportNull$$$0(3);
        }
        if (annotationShortName == null) {
            UnreachableResourceMethodInspection.$$$reportNull$$$0(4);
        }
        if (method == null) {
            UnreachableResourceMethodInspection.$$$reportNull$$$0(5);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{annotationFQN})) != null) {
            String shortName = "@" + annotationShortName;
            problemsHolder.registerProblem((PsiElement)annotation, RSBundle.message("webservices.inspections.rest.resource.method.inspection.problem", shortName), ProblemHighlightType.ERROR, new LocalQuickFix[]{new RemoveElementFix((PsiElement)annotation, RSBundle.message("webservices.inspections.remove.annotation.fix.name", shortName))});
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = RSBundle.message("webservices.inspections.rest.resource.method.inspection.display.name", new Object[0]);
        if (string == null) {
            UnreachableResourceMethodInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = RSBundle.message("webservices.inspections.rest.resource.method.inspection.short.name", new Object[0]);
        if (string == null) {
            UnreachableResourceMethodInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationShortName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/inspections/UnreachableResourceMethodInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/inspections/UnreachableResourceMethodInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotationPresence";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

