/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.TraceConsoleProperties;
import com.intellij.javascript.trace.execution.actions.CloseAllDiagramFilesAction;
import com.intellij.javascript.trace.execution.actions.CloseAllTraceFilesAction;
import com.intellij.javascript.trace.execution.actions.LoadTraceAction;
import com.intellij.javascript.trace.execution.actions.RemoveAllAction;
import com.intellij.javascript.trace.execution.actions.SaveTraceAction;
import com.intellij.javascript.trace.execution.actions.SetEventFilterAction;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.events.EventTree;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import icons.SpyJSIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class EventsToolbarPanel
extends JPanel {
    public EventsToolbarPanel(@NotNull Project project, final @NotNull TraceConsoleProperties properties, @NotNull JComponent parent, @NotNull EventTree eventTree, @NotNull Runnable onTraceLoad, final @NotNull TraceContext traceContext) {
        if (project == null) {
            EventsToolbarPanel.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            EventsToolbarPanel.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            EventsToolbarPanel.$$$reportNull$$$0(2);
        }
        if (eventTree == null) {
            EventsToolbarPanel.$$$reportNull$$$0(3);
        }
        if (onTraceLoad == null) {
            EventsToolbarPanel.$$$reportNull$$$0(4);
        }
        if (traceContext == null) {
            EventsToolbarPanel.$$$reportNull$$$0(5);
        }
        super(new BorderLayout());
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)((Object)eventTree));
        DefaultActionGroup actionGroup = new DefaultActionGroup(null, false);
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        AnAction action = actionsManager.createExpandAllAction((TreeExpander)treeExpander, parent);
        action.getTemplatePresentation().setDescription(TraceBundle.message("console.trace.toolbar.expand", new Object[0]));
        actionGroup.add(action);
        action = actionsManager.createCollapseAllAction((TreeExpander)treeExpander, parent);
        action.getTemplatePresentation().setDescription(TraceBundle.message("console.trace.toolbar.collapse", new Object[0]));
        actionGroup.add(action);
        actionGroup.addSeparator();
        actionGroup.add(actionsManager.createPrevOccurenceAction((OccurenceNavigator)eventTree));
        actionGroup.add(actionsManager.createNextOccurenceAction((OccurenceNavigator)eventTree));
        actionGroup.addSeparator();
        actionGroup.add((AnAction)new ToggleAction(TraceBundle.message("console.trace.toolbar.autoScrollText", new Object[0]), TraceBundle.message("console.trace.toolbar.autoScrollDesc", new Object[0]), AllIcons.General.AutoscrollToSource){

            public boolean isSelected(AnActionEvent e) {
                return properties.getAutoScrollToTrace();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                properties.setAutoScrollToTrace(state);
            }
        });
        actionGroup.addSeparator();
        actionGroup.addAction((AnAction)new SetEventFilterAction(project, traceContext.getTraceSettingsManager()));
        actionGroup.addAction((AnAction)new RemoveAllAction(eventTree, false)).setAsSecondary(true);
        actionGroup.addAction((AnAction)new RemoveAllAction(eventTree, true)).setAsSecondary(true);
        actionGroup.addAction((AnAction)new CloseAllTraceFilesAction(FileEditorManager.getInstance((Project)project))).setAsSecondary(true);
        actionGroup.addAction((AnAction)new CloseAllDiagramFilesAction(FileEditorManager.getInstance((Project)project))).setAsSecondary(true);
        actionGroup.addAction((AnAction)new SaveTraceAction(traceContext.getTraceSession())).setAsSecondary(true);
        actionGroup.addAction((AnAction)new LoadTraceAction(traceContext.getTraceSession(), () -> {
            if (traceContext == null) {
                EventsToolbarPanel.$$$reportNull$$$0(7);
            }
            if (onTraceLoad == null) {
                EventsToolbarPanel.$$$reportNull$$$0(8);
            }
            traceContext.getTraceSettingsManager().setLoaded(true);
            onTraceLoad.run();
        })).setAsSecondary(true);
        actionGroup.addSeparator();
        actionGroup.addAction((AnAction)new ToggleAction(TraceBundle.message("console.trace.toolbar.closeOnStopText", new Object[0]), TraceBundle.message("console.trace.toolbar.closeOnStopDesc", new Object[0]), AllIcons.Actions.Close){

            public boolean isSelected(AnActionEvent e) {
                return properties.needToCloseTraceFilesOnSessionStop();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                properties.setCloseTraceFilesOnSessionStop(state);
            }
        }).setAsSecondary(true);
        actionGroup.addAction((AnAction)new ToggleAction(TraceBundle.message("console.trace.toolbar.closeDiagramsOnStopText", new Object[0]), TraceBundle.message("console.trace.toolbar.closeDiagramsOnStopDesc", new Object[0]), AllIcons.Actions.Close){

            public boolean isSelected(AnActionEvent e) {
                return properties.needToCloseDiagramFilesOnSessionStop();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                properties.setCloseDiagramFilesOnSessionStop(state);
            }
        }).setAsSecondary(true);
        actionGroup.addAction((AnAction)new ToggleAction(TraceBundle.message("console.trace.toolbar.enableRealtimeEvaluationText", new Object[0]), TraceBundle.message("console.trace.toolbar.enableRealtimeEvaluationDesc", new Object[0]), SpyJSIcons.Magnifier){

            public boolean isSelected(AnActionEvent e) {
                return properties.isRealtimeEvaluationEnabled();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                properties.setRealtimeEvaluationEnabled(state);
                traceContext.getTraceSettingsManager().applySettings();
            }
        }).setAsSecondary(true);
        actionGroup.addAction((AnAction)new ToggleAction(TraceBundle.message("console.trace.toolbar.enableSourceMapLookupText", new Object[0]), TraceBundle.message("console.trace.toolbar.enableSourceMapLookupDesc", new Object[0]), SpyJSIcons.Enable_sourceMapLookup){

            public boolean isSelected(AnActionEvent e) {
                return properties.isSourceMapLookupEnabled();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                properties.setSourceMapLookupEnabled(state);
                traceContext.getTraceSettingsManager().applySettings();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                super.update(e);
                e.getPresentation().setEnabledAndVisible(EventsToolbarPanel.this.showSourceMapsActions(traceContext));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/EventsToolbarPanel$5", "update"));
            }
        }).setAsSecondary(true);
        actionGroup.addAction((AnAction)new ToggleAction(TraceBundle.message("console.trace.toolbar.enableSourceMapGenerationText", new Object[0]), TraceBundle.message("console.trace.toolbar.enableSourceMapGenerationDesc", new Object[0]), SpyJSIcons.Enable_sourceMapGeneration){

            public boolean isSelected(AnActionEvent e) {
                return properties.isSourceMapGenerationEnabled();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                properties.setSourceMapGenerationEnabled(state);
                traceContext.getTraceSettingsManager().applySettings();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                super.update(e);
                e.getPresentation().setEnabledAndVisible(EventsToolbarPanel.this.showSourceMapsActions(traceContext));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/EventsToolbarPanel$6", "update"));
            }
        }).setAsSecondary(true);
        actionGroup.addAction((AnAction)new ToggleAction(TraceBundle.message("console.trace.toolbar.alwaysOpenMappedTraceText", new Object[0]), TraceBundle.message("console.trace.toolbar.alwaysOpenMappedTraceDesc", new Object[0]), SpyJSIcons.Open_traceMappedFile){

            public boolean isSelected(AnActionEvent e) {
                return properties.alwaysOpenMappedTraceIfAvailable();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                properties.setAlwaysOpenMappedTraceIfAvailable(state);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                super.update(e);
                e.getPresentation().setEnabledAndVisible(EventsToolbarPanel.this.showSourceMapsActions(traceContext));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/EventsToolbarPanel$7", "update"));
            }
        }).setAsSecondary(true);
        this.add((Component)ActionManager.getInstance().createActionToolbar("SpyJsEventsToolbar", (ActionGroup)actionGroup, true).getComponent(), "Center");
    }

    protected boolean showSourceMapsActions(@NotNull TraceContext traceContext) {
        if (traceContext == null) {
            EventsToolbarPanel.$$$reportNull$$$0(6);
        }
        return !traceContext.getTraceSession().isNodeJsSession();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventTree";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onTraceLoad";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/trace/execution/EventsToolbarPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showSourceMapsActions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

