/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.javascript.trace.execution.code.CodeElement;
import com.intellij.javascript.trace.execution.code.MappedCodePosition;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.common.MappedTraceVirtualFile;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionArgument;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.common.RuntimeReturnStatement;
import com.intellij.javascript.trace.execution.common.RuntimeStatement;
import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.javascript.trace.execution.context.StackFrameContext;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OriginalTraceVirtualFile
extends TraceVirtualFile {
    private final MappedTraceVirtualFile[] myMappedTraceVirtualFiles;

    public OriginalTraceVirtualFile(String url, String content, VirtualFile localFile, MappedTraceVirtualFile[] mappedTraceVirtualFiles, String streamId) {
        super(url, content, localFile, streamId);
        this.setFileType((FileType)JavaScriptFileType.INSTANCE);
        this.setLanguage((Language)JavascriptLanguage.INSTANCE);
        this.myMappedTraceVirtualFiles = mappedTraceVirtualFiles;
    }

    @NotNull
    public TraceVirtualFile getFileToDisplay(@NotNull StackFrameContext context, boolean useMappedSourceIfAvailable) {
        if (context == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(0);
        }
        TraceVirtualFile activeFile = this;
        if (!useMappedSourceIfAvailable) {
            OriginalTraceVirtualFile originalTraceVirtualFile = activeFile;
            if (originalTraceVirtualFile == null) {
                OriginalTraceVirtualFile.$$$reportNull$$$0(1);
            }
            return originalTraceVirtualFile;
        }
        boolean manyOrWrongMappedFiles = false;
        for (RuntimeStatement runtimeStatement : context.getStackFrame().getStatements()) {
            MappedCodePosition mappedCodePosition = runtimeStatement.getCodeRange().getMappedCodePosition();
            if (mappedCodePosition == null) continue;
            if (mappedCodePosition.getMappedFileIndex() >= this.myMappedTraceVirtualFiles.length) {
                manyOrWrongMappedFiles = true;
                break;
            }
            MappedTraceVirtualFile mappedTraceVirtualFile = this.myMappedTraceVirtualFiles[mappedCodePosition.getMappedFileIndex()];
            if (StringUtil.isEmpty((CharSequence)mappedTraceVirtualFile.getContent())) {
                mappedCodePosition.setInvalid();
                continue;
            }
            if (activeFile != this && !((Object)((Object)mappedTraceVirtualFile)).equals((Object)activeFile)) {
                manyOrWrongMappedFiles = true;
                break;
            }
            activeFile = mappedTraceVirtualFile;
        }
        if (manyOrWrongMappedFiles) {
            activeFile = this;
        }
        OriginalTraceVirtualFile originalTraceVirtualFile = activeFile;
        if (originalTraceVirtualFile == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(2);
        }
        return originalTraceVirtualFile;
    }

    @Override
    @NotNull
    public TextRange getFunctionRange(@NotNull Editor editor, @NotNull RuntimeFunctionScope functionScope) {
        if (editor == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(3);
        }
        if (functionScope == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(4);
        }
        TextRange textRange = OriginalTraceVirtualFile.getCodeElementRange(editor, functionScope);
        if (textRange == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    @Override
    @NotNull
    public TextRange getStatementRange(@NotNull Editor editor, @NotNull RuntimeFunctionScope functionScope, @NotNull StaticCodeElement statement) {
        if (editor == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(6);
        }
        if (functionScope == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(7);
        }
        if (statement == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(8);
        }
        TextRange textRange = OriginalTraceVirtualFile.getCodeElementRange(editor, statement);
        if (textRange == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    @Override
    @NotNull
    public TextRange getReturnStatementRange(@NotNull Editor editor, @NotNull RuntimeReturnStatement returnStatement) {
        if (editor == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(10);
        }
        if (returnStatement == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(11);
        }
        TextRange textRange = OriginalTraceVirtualFile.getCodeElementRange(editor, returnStatement);
        if (textRange == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    @Override
    @NotNull
    public TextRange getParamRange(@NotNull Editor editor, @NotNull RuntimeFunctionArgument argument) {
        if (editor == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(13);
        }
        if (argument == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(14);
        }
        TextRange textRange = OriginalTraceVirtualFile.getCodeElementRange(editor, argument);
        if (textRange == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(15);
        }
        return textRange;
    }

    @NotNull
    private static TextRange getCodeElementRange(@NotNull Editor editor, @NotNull CodeElement element) {
        TextRange textRange;
        if (editor == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(16);
        }
        if (element == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(17);
        }
        Document document = editor.getDocument();
        try {
            textRange = element.getCodeRange().convertToTextRange(document);
        }
        catch (Exception ex) {
            TextRange textRange2 = TextRange.EMPTY_RANGE;
            if (textRange2 == null) {
                OriginalTraceVirtualFile.$$$reportNull$$$0(19);
            }
            return textRange2;
        }
        if (textRange == null) {
            OriginalTraceVirtualFile.$$$reportNull$$$0(18);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionScope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/common/OriginalTraceVirtualFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToDisplay";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionRange";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementRange";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnStatementRange";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamRange";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeElementRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileToDisplay";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionRange";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStatementRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getReturnStatementRange";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getParamRange";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCodeElementRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

