/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.events;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.common.EventMetadataExtended;
import com.intellij.javascript.trace.execution.events.EventNode;
import com.intellij.javascript.trace.execution.events.EventStreamNode;
import com.intellij.javascript.trace.execution.events.EventTreeNode;
import com.intellij.javascript.trace.execution.events.NodeWithRemovableChildren;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import icons.SpyJSIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class EventGroupNode
extends EventTreeNode
implements NodeWithRemovableChildren {
    private List<EventNode> myChildren = new ArrayList<EventNode>();
    private long myChildrenCount;
    private double myChildrenTimeAvg;
    private EventStreamNode myParent;
    private String myName;

    public EventGroupNode(EventStreamNode parent, EventNode firstChild) {
        super(parent);
        this.myParent = parent;
        this.myName = firstChild.getName();
        Icon childIcon = firstChild.getIcon();
        this.setIcon(childIcon == null ? SpyJSIcons.EventGroup : (childIcon.equals(SpyJSIcons.SpecialEvent) ? SpyJSIcons.EventGroupSpecial : (childIcon.equals(SpyJSIcons.SpecialEventRecurrence) ? SpyJSIcons.EventGroupSpecialRecurrence : SpyJSIcons.EventGroup)));
        this.setText(this.getPresentation());
        this.setTooltip(this.getPresentation());
    }

    @Override
    public SimpleNode[] getChildren() {
        SimpleNode[] children = new SimpleNode[this.myChildren.size()];
        this.myChildren.toArray(children);
        return children;
    }

    @Override
    protected void setText(PresentationData presentation) {
        presentation.addText(this.myName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.addText(TraceBundle.message("console.trace.doubleSpace", new Object[0]) + Utils.formatExecutionTime(this.myChildrenTimeAvg) + TraceBundle.message("console.trace.timeSuffix", new Object[0]), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        presentation.addText(TraceBundle.message("console.trace.doubleSpace", new Object[0]) + TraceBundle.message("console.trace.multiplierSymbol", new Object[0]) + this.myChildrenCount, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    @Override
    protected void setTooltip(PresentationData presentation) {
        presentation.setTooltip(String.format(TraceBundle.message("console.trace.events.eventGroupTooltipTemplate", new Object[0]), this.getName(), this.myChildrenCount, Utils.formatExecutionTime(this.myChildrenTimeAvg)));
    }

    public void add(EventNode groupMember) {
        if (groupMember.getParent() != this) {
            groupMember.reParent(this);
        }
        this.myChildren.add(0, groupMember);
        this.updateStats();
    }

    @Override
    protected void updateEventData(EventMetadataExtended eventData) {
        this.updateStats();
    }

    private void updateStats() {
        this.myChildrenCount = this.myChildren.size();
        double total = 0.0;
        long childrenWithoutTimeCount = 0L;
        for (EventNode child : this.myChildren) {
            Double time = child.getExecutionTime();
            if (time != null) {
                total += time.doubleValue();
                continue;
            }
            ++childrenWithoutTimeCount;
        }
        long childrenWithTimeCount = this.myChildrenCount - childrenWithoutTimeCount;
        this.myChildrenTimeAvg = childrenWithTimeCount > 0L ? total / (double)childrenWithTimeCount : 0.0;
    }

    public EventNode removeFirstChild() {
        EventNode removed = this.myChildren.remove(this.myChildren.size() - 1);
        this.updateStats();
        this.myParent.eventNodeRemoved(removed);
        return removed;
    }

    @Override
    public void removeChild(EventTreeNode nodeToRemove) {
        if (!(nodeToRemove instanceof EventNode)) {
            return;
        }
        EventNode eventNode = (EventNode)nodeToRemove;
        this.myChildren.remove((Object)eventNode);
        this.myParent.eventNodeRemoved(eventNode);
        this.updateStats();
    }

    public boolean hasChildren() {
        return this.myChildrenCount > 0L;
    }

    public String getName() {
        return this.myName;
    }
}

