/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.uml.editors.DiagramNodeEditorManager;

public class UmlCategorySwitcher
extends DiagramAction
implements Toggleable {
    private final DiagramCategory myCategory;
    private final DiagramBuilder myBuilder;

    public UmlCategorySwitcher(DiagramCategory category, DiagramBuilder builder) {
        super(category.getName(), "", category.getIcon());
        this.myCategory = category;
        this.myBuilder = builder;
    }

    public void perform(AnActionEvent e) {
        DiagramNodeEditorManager.getInstance().stopEditing(this.myBuilder);
        this.myBuilder.getPresentation().setCategoryEnabled(this.myCategory, !this.isEnabled());
        if (this.myCategory.isRefreshDataModel()) {
            this.myBuilder.getDataModel().refreshDataModel();
        }
        this.myBuilder.update(true, this.myBuilder.isPopupMode() || this.myCategory.isRefreshLayout());
        this.myBuilder.getGraph().updateViews();
        if (this.myCategory.isFitContent()) {
            this.myBuilder.getGraph().fitGraph2DView();
        }
    }

    public String getActionName() {
        return (this.isEnabled() ? "Disable " : "Enable ") + this.myCategory.getName();
    }

    public void update(AnActionEvent e) {
        e.getPresentation().putClientProperty("selected", (Object)this.isEnabled());
    }

    private boolean isEnabled() {
        return this.myBuilder.getPresentation().isCategoryEnabled(this.myCategory);
    }
}

