/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.visibility;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.uml.core.actions.visibility.DeselectedVisibilityIcon;
import com.intellij.uml.core.actions.visibility.SelectedVisibilityIcon;
import javax.swing.Icon;

public class ChangeVisibilityLevelAction
extends DiagramAction {
    private static final SelectedVisibilityIcon SELECTED_ICON = new SelectedVisibilityIcon();
    private static final DeselectedVisibilityIcon DESELECTED_ICON = new DeselectedVisibilityIcon();
    private final DiagramVisibilityManager myVisibilityManager;
    private final VisibilityLevel myLevel;
    private final DiagramBuilder myBuilder;

    public ChangeVisibilityLevelAction(DiagramVisibilityManager visibilityManager, VisibilityLevel level, DiagramBuilder builder) {
        super(level.getDisplayName(), "", ChangeVisibilityLevelAction.getActionIcon(visibilityManager, level));
        this.myVisibilityManager = visibilityManager;
        this.myLevel = level;
        this.myBuilder = builder;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setIcon(ChangeVisibilityLevelAction.getActionIcon(this.myVisibilityManager, this.myLevel));
    }

    public void perform(AnActionEvent e) {
        this.myVisibilityManager.setCurrentVisibilityLevel(this.myLevel);
        this.myBuilder.getDataModel().refreshDataModel();
        this.myBuilder.update(true, true);
        this.myBuilder.getGraph().updateViews();
        if (this.myVisibilityManager.isRelayoutNeeded()) {
            this.myBuilder.relayout();
        }
    }

    private static Icon getActionIcon(DiagramVisibilityManager mgr, VisibilityLevel level) {
        return level == mgr.getCurrentVisibilityLevel() ? SELECTED_ICON : DESELECTED_ICON;
    }

    public String getActionName() {
        return "Change Visibility to " + this.myLevel.getDisplayName();
    }
}

