/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.diff;

import com.intellij.diagram.ChangeTracker;
import com.intellij.diagram.DiagramChangesProvider;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.uml.diff.DiffUmlProvider;
import com.intellij.uml.diff.UmlDiffEdge;
import com.intellij.uml.diff.UmlDiffElement;
import com.intellij.uml.diff.UmlDiffNode;
import com.intellij.uml.diff.UmlDiffNodeWithoutTracker;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffUmlDataModel
extends DiagramDataModel<UmlDiffElement> {
    private final Map<String, UmlDiffNode> myNodes;
    private ArrayList<UmlDiffEdge> myEdges;
    private PsiFile myStub;

    public DiffUmlDataModel(Project project, UmlDiffElement element, LocalChangeList localChangeList) {
        super(project, (DiagramProvider)DiffUmlProvider.INSTANCE);
        LocalChangeList changeList;
        this.myNodes = new HashMap<String, UmlDiffNode>();
        this.myEdges = new ArrayList();
        this.myStub = PsiFileFactory.getInstance((Project)project).createFileFromText("stub.txt", "");
        VcsFileRevision revision = element == null ? null : element.getRevision();
        Object object = changeList = element == null ? localChangeList : element.getVcs().loadRevisions(element.getInitialVirtualFile(), element.getRevision().getRevisionNumber());
        if (changeList != null) {
            Collection<Change> changes = DiffUmlDataModel.removeUnnecessary(changeList.getChanges());
            ArrayList<ChangeTracker> trackers = new ArrayList<ChangeTracker>();
            for (Change change : changes) {
                AbstractVcs vcs;
                DiagramChangesProvider provider = UmlDiffElement.acceptChange(change);
                PsiFile before = this.createPsiFile(project, change.getBeforeRevision());
                PsiFile after = this.createPsiFile(project, change.getAfterRevision());
                if (before == null && after == null) continue;
                VirtualFile vf = change.getVirtualFile();
                Object object2 = element != null ? element.getVcs() : (vcs = vf == null ? null : VcsUtil.getVcsFor((Project)project, (VirtualFile)vf));
                if (provider != null) {
                    ChangeTracker tracker = provider.createTracker(project, before, after);
                    if (tracker == null) continue;
                    trackers.add(tracker);
                    Map nodeElements = tracker.getNodeElements();
                    for (PsiNamedElement key : nodeElements.keySet()) {
                        UmlDiffNode node = new UmlDiffNode(new UmlDiffElement(vcs, revision, key, tracker, (FileStatus)nodeElements.get(key)));
                        this.myNodes.put(DiffUmlDataModel.createQualifiedName(tracker, key, vf), node);
                    }
                    continue;
                }
                UmlDiffElement diff = new UmlDiffElement(vcs, element == null ? null : revision, (PsiNamedElement)(after == null ? before : after), null, change.getFileStatus());
                if (vf == null) continue;
                this.myNodes.put("unknown://" + vf.getPath(), new UmlDiffNodeWithoutTracker(diff, before, after));
            }
            for (ChangeTracker tracker : trackers) {
                for (ChangeTracker.RelationshipInfo info : tracker.getRelationships()) {
                    PsiNamedElement toElement;
                    UmlDiffNode from = this.myNodes.get(DiffUmlDataModel.createQualifiedName(tracker, info.fromFQN));
                    UmlDiffNode to = this.myNodes.get(DiffUmlDataModel.createQualifiedName(tracker, info.toFQN));
                    if (to == null && (toElement = tracker.findElementByFQN(project, info.toFQN)) != null) {
                        to = new UmlDiffNode(new UmlDiffElement(null, null, toElement, null, FileStatus.NOT_CHANGED));
                        this.myNodes.put(DiffUmlDataModel.createQualifiedName(tracker, info.toFQN), to);
                    }
                    if (from == null || to == null) continue;
                    this.myEdges.add(new UmlDiffEdge(from, to, info));
                }
            }
        }
    }

    public DiffUmlDataModel(Project project, @NotNull LocalChangeList changeList) {
        if (changeList == null) {
            DiffUmlDataModel.$$$reportNull$$$0(0);
        }
        super(project, (DiagramProvider)DiffUmlProvider.INSTANCE);
        this.myNodes = new HashMap<String, UmlDiffNode>();
        this.myEdges = new ArrayList();
    }

    private static String createQualifiedName(ChangeTracker tracker, PsiNamedElement element, VirtualFile virtualFile) {
        return DiffUmlDataModel.createQualifiedName(tracker, tracker.getQualifiedName(element, virtualFile));
    }

    private static String createQualifiedName(ChangeTracker tracker, String name) {
        return tracker.getNotNullFile().getLanguage().getID() + "://" + name;
    }

    private static Collection<Change> removeUnnecessary(Collection<Change> changes) {
        HashMap<String, Change> deleted = new HashMap<String, Change>();
        HashMap<String, Change> moved = new HashMap<String, Change>();
        for (Change change : changes) {
            ContentRevision before;
            if (change.getType() == Change.Type.DELETED) {
                before = change.getBeforeRevision();
                if (before == null) continue;
                deleted.put(before.getFile().getPath(), change);
                continue;
            }
            if (change.getType() != Change.Type.MOVED || (before = change.getBeforeRevision()) == null) continue;
            moved.put(before.getFile().getPath(), change);
        }
        for (String path : moved.keySet()) {
            Change change = (Change)deleted.get(path);
            if (change == null) continue;
            changes.remove(change);
        }
        return changes;
    }

    @Nullable
    private PsiFile createPsiFile(Project project, @Nullable ContentRevision content) {
        if (content != null) {
            FilePath path = content.getFile();
            String text = null;
            try {
                text = content.getContent();
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
            if (text != null) {
                PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(path.getName(), path.getFileType(), (CharSequence)text);
                file.putUserData(PsiFileFactory.ORIGINAL_FILE, (Object)this.myStub);
                return file;
            }
        }
        return null;
    }

    @NotNull
    public Collection<DiagramNode<UmlDiffElement>> getNodes() {
        Collection<UmlDiffNode> nodes = this.myNodes.values();
        ArrayList<UmlDiffNode> arrayList = new ArrayList<UmlDiffNode>(nodes);
        if (arrayList == null) {
            DiffUmlDataModel.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public Collection<DiagramEdge<UmlDiffElement>> getEdges() {
        ArrayList<UmlDiffEdge> arrayList = new ArrayList<UmlDiffEdge>(this.myEdges);
        if (arrayList == null) {
            DiffUmlDataModel.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public String getNodeName(DiagramNode<UmlDiffElement> n) {
        String string = ((UmlDiffElement)n.getIdentifyingElement()).getNodeName();
        if (string == null) {
            DiffUmlDataModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public DiagramNode<UmlDiffElement> addElement(UmlDiffElement element) {
        return null;
    }

    public void refreshDataModel() {
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        ModificationTracker modificationTracker = new ModificationTracker(){

            public long getModificationCount() {
                return 0L;
            }
        };
        if (modificationTracker == null) {
            DiffUmlDataModel.$$$reportNull$$$0(4);
        }
        return modificationTracker;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/diff/DiffUmlDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/diff/DiffUmlDataModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

