/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project.actions;

import com.intellij.ide.util.gotoByName.SimpleChooseByNameModel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.uml.project.ui.ModulesListCellRenderer;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class ModulesChooseByNameModel
extends SimpleChooseByNameModel
implements DumbAware {
    private final Map<String, Module> modules;
    private final Map<String, Library> libraries;

    ModulesChooseByNameModel(@NotNull Project project) {
        if (project == null) {
            ModulesChooseByNameModel.$$$reportNull$$$0(0);
        }
        super(project, "Enter module name", null);
        this.modules = new HashMap<String, Module>();
        this.libraries = new HashMap<String, Library>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            this.modules.put(module.getName(), module);
        }
        for (Module module : ProjectLibraryTable.getInstance((Project)project).getLibraries()) {
            this.libraries.put(module.getName(), (Library)module);
        }
    }

    public String[] getNames() {
        return ArrayUtil.mergeArrays((String[])ArrayUtil.toStringArray(this.modules.keySet()), (String[])ArrayUtil.toStringArray(this.libraries.keySet()));
    }

    protected Object[] getElementsByName(String name, String pattern) {
        Object[] objectArray;
        Module module = this.modules.get(name);
        Library library = this.libraries.get(name);
        if (module == null && library == null) {
            objectArray = AnAction.EMPTY_ARRAY;
        } else if (module != null && library == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = module;
        } else if (module == null && library != null) {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = library;
        } else {
            Object[] objectArray4 = new Object[2];
            objectArray4[0] = module;
            objectArray = objectArray4;
            objectArray4[1] = library;
        }
        return objectArray;
    }

    public ListCellRenderer getListCellRenderer() {
        return new ModulesListCellRenderer();
    }

    public String getElementName(Object element) {
        return element instanceof Module ? ((Module)element).getName() : (element instanceof Library ? ((Library)element).getName() : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uml/project/actions/ModulesChooseByNameModel", "<init>"));
    }
}

