/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.heroku.agent.cloud;

import com.heroku.api.HerokuAPI;
import com.heroku.api.connection.JerseyClientAsyncConnection;
import com.heroku.api.exception.HerokuAPIException;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import java.io.IOException;

public class HerokuApiTaskProvider {
    private static final long REQUEST_DELAY_MSEC = 6000L;
    private static final int RATE_LIMIT_LOW = 100;
    private final HerokuAPI myApi;
    private final CloudAgentErrorHandler myErrorHandler;
    private final CloudAgentLogger myLogger;
    private long myLastRequestTime;
    private int myRemainingRateLimit;

    public HerokuApiTaskProvider(HerokuAPI api, CloudAgentErrorHandler errorHandler, CloudAgentLogger logger) {
        this.myApi = api;
        this.myErrorHandler = errorHandler;
        this.myLogger = logger;
    }

    public abstract class ApiSilentTask<T>
    extends ApiTask<T> {
        @Override
        protected void onError(Exception ex) {
            HerokuApiTaskProvider.this.myLogger.debugEx(ex);
        }
    }

    public abstract class ApiTask<T> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public T perform() {
            T deltaTime2222222222;
            long deltaTime2222222222;
            long currentTime = System.currentTimeMillis();
            if (HerokuApiTaskProvider.this.myRemainingRateLimit < 100 && (deltaTime2222222222 = currentTime - HerokuApiTaskProvider.this.myLastRequestTime) < 6000L) {
                try {
                    Thread.sleep(6000L - deltaTime2222222222);
                }
                catch (InterruptedException e) {
                    HerokuApiTaskProvider.this.myLogger.debugEx((Exception)e);
                }
            }
            HerokuApiTaskProvider.this.myLastRequestTime = currentTime;
            try {
                deltaTime2222222222 = this.doPerform(HerokuApiTaskProvider.this.myApi);
                Integer remainingRateLimit = ((JerseyClientAsyncConnection)HerokuApiTaskProvider.this.myApi.getConnection()).getRemainingRateLimit();
                HerokuApiTaskProvider.this.myRemainingRateLimit = remainingRateLimit == null ? Integer.MAX_VALUE : remainingRateLimit;
            }
            catch (HerokuAPIException ex) {
                this.onError((Exception)((Object)ex));
                T t = null;
                Integer remainingRateLimit = ((JerseyClientAsyncConnection)HerokuApiTaskProvider.this.myApi.getConnection()).getRemainingRateLimit();
                HerokuApiTaskProvider.this.myRemainingRateLimit = remainingRateLimit == null ? Integer.MAX_VALUE : remainingRateLimit;
                HerokuApiTaskProvider.this.myLogger.debug("remaining rate limit: " + HerokuApiTaskProvider.this.myRemainingRateLimit);
                return t;
            }
            catch (IOException ex2) {
                this.onError(ex2);
                T t = null;
                Integer remainingRateLimit = ((JerseyClientAsyncConnection)HerokuApiTaskProvider.this.myApi.getConnection()).getRemainingRateLimit();
                HerokuApiTaskProvider.this.myRemainingRateLimit = remainingRateLimit == null ? Integer.MAX_VALUE : remainingRateLimit;
                {
                    catch (Throwable throwable) {
                        Integer remainingRateLimit2 = ((JerseyClientAsyncConnection)HerokuApiTaskProvider.this.myApi.getConnection()).getRemainingRateLimit();
                        HerokuApiTaskProvider.this.myRemainingRateLimit = remainingRateLimit2 == null ? Integer.MAX_VALUE : remainingRateLimit2;
                        HerokuApiTaskProvider.this.myLogger.debug("remaining rate limit: " + HerokuApiTaskProvider.this.myRemainingRateLimit);
                        throw throwable;
                    }
                }
                HerokuApiTaskProvider.this.myLogger.debug("remaining rate limit: " + HerokuApiTaskProvider.this.myRemainingRateLimit);
                return t;
            }
            HerokuApiTaskProvider.this.myLogger.debug("remaining rate limit: " + HerokuApiTaskProvider.this.myRemainingRateLimit);
            return deltaTime2222222222;
        }

        protected abstract T doPerform(HerokuAPI var1) throws HerokuAPIException, IOException;

        protected void onError(Exception ex) {
            HerokuApiTaskProvider.this.myErrorHandler.onError(ex.toString());
        }
    }
}

