/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.compiler;

import com.intellij.flex.compiler.OutputLogger;
import com.intellij.flex.compiler.SdkSpecificHandler;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.common.Configuration;
import macromedia.asc.embedding.LintEvaluator;

public class CompilationThread
extends Thread {
    private static int omitTraceCompilationsCount = 0;
    private static int traceCompilationsCount = 0;
    private static final Object lock = new Object();
    private final boolean mySwf;
    private final SdkSpecificHandler mySdkSpecificHandler;
    private final String[] myParams;
    private final OutputLogger myLogger;

    public CompilationThread(boolean isSwf, SdkSpecificHandler sdkSpecificHandler, String[] params, OutputLogger logger) {
        this.mySwf = isSwf;
        this.mySdkSpecificHandler = sdkSpecificHandler;
        this.myParams = params;
        this.myLogger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.mySdkSpecificHandler.initThreadLocals(this.myLogger);
            boolean omitTrace = this.mySdkSpecificHandler.isOmitTrace(this.mySwf, this.myParams);
            try {
                CompilationThread.acquire(omitTrace);
                this.mySdkSpecificHandler.setupOmitTraceOption(omitTrace);
                if (this.mySwf) {
                    this.mySdkSpecificHandler.compileSwf(this.myParams);
                } else {
                    this.mySdkSpecificHandler.compileSwc(this.myParams);
                }
            }
            finally {
                CompilationThread.release(omitTrace);
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
        catch (Throwable t) {
            this.logError(t);
            System.exit(1);
        }
        finally {
            this.myLogger.log("Compilation finished");
            this.mySdkSpecificHandler.cleanThreadLocals();
            System.gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void acquire(boolean omitTrace) throws InterruptedException {
        Object object = lock;
        synchronized (object) {
            while (omitTrace && traceCompilationsCount > 0 || !omitTrace && omitTraceCompilationsCount > 0) {
                lock.wait();
            }
            if (omitTrace) {
                ++omitTraceCompilationsCount;
            } else {
                ++traceCompilationsCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void release(boolean omitTrace) {
        Object object = lock;
        synchronized (object) {
            if (omitTrace) {
                --omitTraceCompilationsCount;
            } else {
                --traceCompilationsCount;
            }
            lock.notifyAll();
        }
    }

    private void logError(Throwable e) {
        if (e instanceof ILocalizableMessage) {
            this.myLogger.log((ILocalizableMessage)e);
        } else {
            this.myLogger.log("Error: " + e.toString());
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                this.myLogger.log("\tat " + stackTraceElement.toString());
            }
        }
    }

    static {
        try {
            Configuration.getAliases();
            LintEvaluator.getWarningDefaults();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

