/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.util.ModuleUtils;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileManager {
    private static final Logger LOG = Logger.getInstance(ConfigFileManager.class);
    private final Module myModule;

    public ConfigFileManager(Module module) {
        this.myModule = module;
    }

    private String getFileName() {
        return this.myModule.getName();
    }

    private String getFileNameWithExt() {
        return this.getFileName() + ".properties";
    }

    private VirtualFile getConfigFileDirectory(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            ConfigFileManager.$$$reportNull$$$0(0);
        }
        return ModuleUtils.getModuleRoot(rootModel);
    }

    public VirtualFile findConfigFile() {
        VirtualFile configFileDirectory = this.getConfigFileDirectory((ModuleRootModel)ModuleRootManager.getInstance((Module)this.myModule));
        if (configFileDirectory == null) {
            return null;
        }
        return configFileDirectory.findChild(this.getFileNameWithExt());
    }

    @Nullable
    public VirtualFile createConfigFile(final @NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            ConfigFileManager.$$$reportNull$$$0(1);
        }
        RunResult result = new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                result.setResult((Object)ConfigFileManager.this.doCreateConfigFile(rootModel));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/dmserver/artifacts/ConfigFileManager$1", "run"));
            }
        }.executeSilently();
        result.logException(LOG);
        return (VirtualFile)result.getResultObject();
    }

    private VirtualFile doCreateConfigFile(@NotNull ModuleRootModel rootModel) throws IOException {
        VirtualFile configFileDirectory;
        VirtualFile result;
        if (rootModel == null) {
            ConfigFileManager.$$$reportNull$$$0(2);
        }
        if ((result = (configFileDirectory = this.getConfigFileDirectory(rootModel)).findChild(this.getFileNameWithExt())) == null) {
            result = configFileDirectory.createChildData((Object)this, this.getFileNameWithExt());
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "rootModel";
        objectArray2[1] = "com/intellij/dmserver/artifacts/ConfigFileManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigFileDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfigFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doCreateConfigFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

