/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.deploy.jmx;

import com.intellij.dmserver.deploy.RepositoryIdentity;
import com.intellij.dmserver.deploy.jmx.AbstractDMConnectorCommand;
import com.intellij.dmserver.run.DMServerInstance;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.jetbrains.annotations.NonNls;

public abstract class ConnectorRepositoryStatusCommandBase
extends AbstractDMConnectorCommand<List<RepositoryIdentity>> {
    @NonNls
    private static final String JMX_ATTR_ALL_ARTIFACT_DESCRIPTOR_SUMMARIES = "AllArtifactDescriptorSummaries";

    protected ConnectorRepositoryStatusCommandBase(DMServerInstance dmServer) {
        super(dmServer);
    }

    @Override
    protected List<RepositoryIdentity> doExecute(MBeanServerConnection connection) throws JMException, IOException {
        CompositeData[] attributeValue = (CompositeData[])connection.getAttribute(this.getRepositoryMBean(), JMX_ATTR_ALL_ARTIFACT_DESCRIPTOR_SUMMARIES);
        ArrayList<RepositoryIdentity> result = new ArrayList<RepositoryIdentity>();
        for (CompositeData attributeValueItem : attributeValue) {
            result.add(new RepositoryIdentity(attributeValueItem));
        }
        return result;
    }

    protected abstract ObjectName getRepositoryMBean();
}

