/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.editor;

import com.intellij.dmserver.editor.ManifestFileEditor;
import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.facet.FacetFinder;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestFileType;

public class ManifestFileEditorProvider
implements FileEditorProvider,
DumbAware {
    @NonNls
    private static final String TYPE_ID = "dm-manifest-editor";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ManifestFileEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ManifestFileEditorProvider.$$$reportNull$$$0(1);
        }
        if (file.isDirectory() || !file.isValid()) {
            return false;
        }
        FileType fileType = file.getFileType();
        if (!(fileType instanceof ManifestFileType)) {
            return false;
        }
        return ManifestFileEditorProvider.findBundleFacet(project, file) != null;
    }

    private static DMBundleFacet findBundleFacet(Project project, VirtualFile file) {
        FacetFinder facetFinder = FacetFinder.getInstance((Project)project);
        return (DMBundleFacet)facetFinder.findFacet(file, DMBundleFacet.ID);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ManifestFileEditorProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ManifestFileEditorProvider.$$$reportNull$$$0(3);
        }
        ManifestFileEditor manifestFileEditor = new ManifestFileEditor(project, file);
        if (manifestFileEditor == null) {
            ManifestFileEditorProvider.$$$reportNull$$$0(4);
        }
        return manifestFileEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        if (TYPE_ID == null) {
            ManifestFileEditorProvider.$$$reportNull$$$0(5);
        }
        return TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            ManifestFileEditorProvider.$$$reportNull$$$0(6);
        }
        return fileEditorPolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dmserver/editor/ManifestFileEditorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dmserver/editor/ManifestFileEditorProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTypeId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

