/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.facet.DMBundleFacetConfiguration;
import com.intellij.dmserver.facet.DMModuleFacetSettingsPanel;
import com.intellij.dmserver.facet.DMWebFacetFrameworkSupportProvider;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelAdapter;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMModuleBundleFacetSettingsPanel
implements DMModuleFacetSettingsPanel<DMBundleFacetConfiguration> {
    private JCheckBox mySpringDMSupportCheckBox;
    private JPanel myMainPanel;
    private JCheckBox myWebModuleCheckBox;
    private JPanel myWebModulePanel;
    private DMWebFacetFrameworkSupportProvider myWebSupportProvider;
    private FrameworkSupportConfigurable myWebSupportConfigurable;
    private String myWebVersionName;
    private boolean myIsCreateWebConfigFile;
    private Module myConfiguredModule;
    private ModulesProvider myModulesProvider;
    private boolean mySpringSupportUpdated;
    private boolean myWebSupportUpdated;

    public DMModuleBundleFacetSettingsPanel() {
        this.$$$setupUI$$$();
    }

    @Override
    public void init(@Nullable Project project, @Nullable Module configuredModule, @NotNull ModulesProvider modulesProvider, @NotNull Disposable parentDisposable) {
        if (modulesProvider == null) {
            DMModuleBundleFacetSettingsPanel.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            DMModuleBundleFacetSettingsPanel.$$$reportNull$$$0(1);
        }
        this.myConfiguredModule = configuredModule;
        this.myModulesProvider = modulesProvider;
        this.mySpringDMSupportCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMModuleBundleFacetSettingsPanel.this.mySpringSupportUpdated = true;
            }
        });
        this.myWebModuleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMModuleBundleFacetSettingsPanel.this.myWebSupportUpdated = true;
            }
        });
    }

    public void initFrameworkContribution(DMWebFacetFrameworkSupportProvider webSupportProvider, final FrameworkSupportModel model) {
        final String springProviderId = FacetBasedFrameworkSupportProvider.getProviderId((FacetTypeId)SpringFacet.FACET_TYPE_ID);
        this.mySpringDMSupportCheckBox.setSelected(model.isFrameworkSelected(springProviderId));
        model.addFrameworkListener((FrameworkSupportModelListener)new FrameworkSupportModelAdapter(){
            boolean myInSpringSelectionUpdate = false;

            public void frameworkSelected(@NotNull FrameworkSupportProvider provider) {
                if (provider == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.onFrameworkSelectionChanged(provider, true);
            }

            public void frameworkUnselected(@NotNull FrameworkSupportProvider provider) {
                if (provider == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.onFrameworkSelectionChanged(provider, false);
            }

            private void onFrameworkSelectionChanged(FrameworkSupportProvider provider, boolean selected) {
                if (springProviderId.equals(provider.getId()) && !this.myInSpringSelectionUpdate) {
                    try {
                        this.myInSpringSelectionUpdate = true;
                        DMModuleBundleFacetSettingsPanel.this.mySpringDMSupportCheckBox.setSelected(selected);
                    }
                    finally {
                        this.myInSpringSelectionUpdate = false;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "provider";
                objectArray2[1] = "com/intellij/dmserver/facet/DMModuleBundleFacetSettingsPanel$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "frameworkSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "frameworkUnselected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.mySpringDMSupportCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                model.setFrameworkComponentEnabled(springProviderId, DMModuleBundleFacetSettingsPanel.this.mySpringDMSupportCheckBox.isSelected());
            }
        });
        this.myWebSupportProvider = webSupportProvider;
        this.myWebSupportConfigurable = webSupportProvider.createConfigurable(model);
        this.myWebModulePanel.add(this.myWebSupportConfigurable.getComponent());
        this.myWebModuleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMModuleBundleFacetSettingsPanel.this.updateEnablement();
            }
        });
    }

    @Override
    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DMModuleBundleFacetSettingsPanel.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Override
    public void load(@NotNull DMBundleFacetConfiguration configuration) {
        if (configuration == null) {
            DMModuleBundleFacetSettingsPanel.$$$reportNull$$$0(3);
        }
        this.mySpringDMSupportCheckBox.setSelected(configuration.getIsSpringDM());
        this.myWebModuleCheckBox.setSelected(configuration.getIsWebModule());
        this.myWebVersionName = configuration.getWebFrameworkVersionName();
        this.myIsCreateWebConfigFile = configuration.getIsCreateWebConfigFile();
        this.mySpringSupportUpdated = false;
        this.myWebSupportUpdated = false;
    }

    private boolean getSupportSelection(boolean selectionUpdated, boolean uiSelection, FacetTypeId<?> facetTypeId) {
        return selectionUpdated || this.myConfiguredModule == null ? uiSelection : !this.myModulesProvider.getFacetModel(this.myConfiguredModule).getFacetsByType(facetTypeId).isEmpty();
    }

    @Override
    public void apply(@NotNull DMBundleFacetConfiguration configuration) {
        if (configuration == null) {
            DMModuleBundleFacetSettingsPanel.$$$reportNull$$$0(4);
        }
        this.doSave(configuration, this.getSupportSelection(this.mySpringSupportUpdated, this.mySpringDMSupportCheckBox.isSelected(), SpringFacet.FACET_TYPE_ID), this.getSupportSelection(this.myWebSupportUpdated, this.myWebModuleCheckBox.isSelected(), WebFacet.ID));
        this.mySpringSupportUpdated = false;
        this.myWebSupportUpdated = false;
    }

    @Override
    public void save(@NotNull DMBundleFacetConfiguration configuration) {
        if (configuration == null) {
            DMModuleBundleFacetSettingsPanel.$$$reportNull$$$0(5);
        }
        this.doSave(configuration, this.mySpringDMSupportCheckBox.isSelected(), this.myWebModuleCheckBox.isSelected());
    }

    private void doSave(@NotNull DMBundleFacetConfiguration configuration, boolean springSupportSelection, boolean webSupportSelection) {
        if (configuration == null) {
            DMModuleBundleFacetSettingsPanel.$$$reportNull$$$0(6);
        }
        configuration.setIsSpringDM(springSupportSelection);
        configuration.setIsWebModule(webSupportSelection);
        configuration.setWebFrameworkVersionName(this.myWebSupportProvider == null ? this.myWebVersionName : this.myWebSupportConfigurable.getSelectedVersion().getVersionName());
        configuration.setIsCreateWebConfigFile(this.myWebSupportProvider == null ? this.myIsCreateWebConfigFile : this.myWebSupportProvider.isCreateConfigFile(this.myWebSupportConfigurable.getSelectedVersion().getVersionName()));
    }

    @Override
    public void updateEnablement() {
        DMModuleBundleFacetSettingsPanel.setEnabledRecursively(this.myWebModulePanel, this.myWebModuleCheckBox.isSelected());
    }

    private static void setEnabledRecursively(Component component, boolean enabled) {
        component.setEnabled(enabled);
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                DMModuleBundleFacetSettingsPanel.setEnabledRecursively(child, enabled);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dmserver/facet/DMModuleBundleFacetSettingsPanel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dmserver/facet/DMModuleBundleFacetSettingsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doSave";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySpringDMSupportCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleBundleFacetSettingsPanel.spring.dm.support"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(89, 22), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myWebModuleCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleBundleFacetSettingsPanel.web.module"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWebModulePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

