/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.integration;

import com.intellij.dmserver.integration.DMServerRepositoryEditor;
import com.intellij.dmserver.integration.DMServerRepositoryExternalItem;
import com.intellij.dmserver.integration.DMServerRepositoryFolderDialog;
import com.intellij.dmserver.integration.DMServerRepositoryItem;
import com.intellij.dmserver.integration.DMServerRepositoryItem20Base;
import com.intellij.dmserver.integration.DMServerRepositoryWatchedItem;
import com.intellij.dmserver.integration.WildcardsFinder;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMServerRepositoryFolderDialog20
extends DMServerRepositoryFolderDialog<DMServerRepositoryItem20Base> {
    private final List<Behavior<?>> myBehaviors;
    private Behavior<?> myBehavior;
    private DMServerRepositoryItem20Base myInitialItem;

    public DMServerRepositoryFolderDialog20(DMServerRepositoryEditor parent) {
        super(parent);
        ButtonGroup radioGroup = new ButtonGroup();
        this.myBehaviors = Arrays.asList(new WatchedBehavior(), new ExternalBehavior());
        for (final Behavior<?> behavior : this.myBehaviors) {
            radioGroup.add(behavior.getRadioButton());
            behavior.getRadioButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DMServerRepositoryFolderDialog20.this.doSetBehavior(behavior);
                }
            });
        }
        this.setBehavior(this.myBehaviors.get(0));
    }

    @Override
    @Nullable
    protected DMServerRepositoryItem20Base createItem() {
        return this.myBehavior.createItem();
    }

    @Override
    public void setItem(DMServerRepositoryItem20Base item) {
        this.myInitialItem = item;
        for (Behavior<?> behavior : this.myBehaviors) {
            if (!behavior.load(item)) continue;
            this.setBehavior(behavior);
            break;
        }
    }

    private void setBehavior(Behavior behavior) {
        behavior.getRadioButton().setSelected(true);
        this.doSetBehavior(behavior);
    }

    private void doSetBehavior(Behavior behavior) {
        this.myBehavior = behavior;
        this.myBehavior.activate();
    }

    private boolean checkNameNotUnique() {
        String name = this.getNameTextField().getText();
        for (DMServerRepositoryItem item : this.getParent().getRepositoryItems()) {
            DMServerRepositoryItem20Base item20;
            if (!(item instanceof DMServerRepositoryItem20Base) || (item20 = (DMServerRepositoryItem20Base)item) == this.myInitialItem || !name.equals(item20.getName())) continue;
            this.setErrorText(DmServerBundle.message("DMServerRepositoryFolderDialog20.warning.name.not.unique", new Object[0]), this.getNameTextField());
            return true;
        }
        return false;
    }

    @Override
    protected String getPathText(JTextField component) {
        return this.myBehavior.getText(component);
    }

    @Override
    protected void setPathText(JTextField component, @NotNull String text) {
        if (text == null) {
            DMServerRepositoryFolderDialog20.$$$reportNull$$$0(0);
        }
        this.myBehavior.setText(component, text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dmserver/integration/DMServerRepositoryFolderDialog20", "setPathText"));
    }

    private class ExternalBehavior
    extends Behavior<DMServerRepositoryExternalItem> {
        private ExternalBehavior() {
        }

        @Override
        public void activate() {
            WildcardsFinder wildcardsFinder;
            String path = DMServerRepositoryFolderDialog20.this.getPathTextField().getText();
            if (!StringUtil.isEmpty((String)path) && !(wildcardsFinder = new WildcardsFinder(DMServerRepositoryFolderDialog20.this.getPathTextField().getTextField().getText())).hasWildcards()) {
                DMServerRepositoryFolderDialog20.this.getPathTextField().setText(path + "/" + "{artifact}");
            }
            DMServerRepositoryFolderDialog20.this.getWatchedIntervalTextField().setEnabled(false);
            DMServerRepositoryFolderDialog20.this.getWatchedIntervalTextField().setText("");
        }

        @Override
        @Nullable
        public DMServerRepositoryExternalItem createItem() {
            if (DMServerRepositoryFolderDialog20.this.checkEmpty(DMServerRepositoryFolderDialog20.this.getNameTextField(), DmServerBundle.message("DMServerRepositoryFolderDialog20.warning.empty.name", new Object[0])) || DMServerRepositoryFolderDialog20.this.checkNameNotUnique() || DMServerRepositoryFolderDialog20.this.checkEmpty(DMServerRepositoryFolderDialog20.this.getPathTextField().getTextField(), DmServerBundle.message("DMServerRepositoryFolderDialog20.warning.empty.path", new Object[0]))) {
                return null;
            }
            DMServerRepositoryExternalItem result = new DMServerRepositoryExternalItem();
            result.setName(DMServerRepositoryFolderDialog20.this.getNameTextField().getText());
            result.setPath(DMServerRepositoryFolderDialog20.this.getPathTextField().getText());
            return result;
        }

        @Override
        public JRadioButton getRadioButton() {
            return DMServerRepositoryFolderDialog20.this.getExternalRadioButton();
        }

        public String getText(JTextField component) {
            return DMServerRepositoryFolderDialog20.this.getPathWithWildcardsText(component);
        }

        public void setText(JTextField component, @NotNull String text) {
            if (text == null) {
                ExternalBehavior.$$$reportNull$$$0(0);
            }
            DMServerRepositoryFolderDialog20.this.setPathWithWildcardsText(component, text);
        }

        @Override
        protected Class<DMServerRepositoryExternalItem> getItemClass() {
            return DMServerRepositoryExternalItem.class;
        }

        @Override
        protected void doLoad(DMServerRepositoryExternalItem item) {
            DMServerRepositoryFolderDialog20.this.getNameTextField().setText(item.getName());
            DMServerRepositoryFolderDialog20.this.getPathTextField().setText(item.getPath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dmserver/integration/DMServerRepositoryFolderDialog20$ExternalBehavior", "setText"));
        }
    }

    private class WatchedBehavior
    extends Behavior<DMServerRepositoryWatchedItem> {
        private WatchedBehavior() {
        }

        @Override
        public void activate() {
            WildcardsFinder wildcardsFinder;
            String path = DMServerRepositoryFolderDialog20.this.getPathTextField().getText();
            if (!StringUtil.isEmpty((String)path) && (wildcardsFinder = new WildcardsFinder(DMServerRepositoryFolderDialog20.this.getPathTextField().getTextField().getText())).hasWildcards()) {
                DMServerRepositoryFolderDialog20.this.getPathTextField().setText(wildcardsFinder.getPath());
            }
            DMServerRepositoryFolderDialog20.this.getWatchedIntervalTextField().setEnabled(true);
        }

        @Override
        @Nullable
        public DMServerRepositoryWatchedItem createItem() {
            if (DMServerRepositoryFolderDialog20.this.checkEmpty(DMServerRepositoryFolderDialog20.this.getNameTextField(), DmServerBundle.message("DMServerRepositoryFolderDialog20.warning.empty.name", new Object[0])) || DMServerRepositoryFolderDialog20.this.checkNameNotUnique() || DMServerRepositoryFolderDialog20.this.checkEmpty(DMServerRepositoryFolderDialog20.this.getPathTextField().getTextField(), DmServerBundle.message("DMServerRepositoryFolderDialog20.warning.empty.path", new Object[0]))) {
                return null;
            }
            DMServerRepositoryWatchedItem result = new DMServerRepositoryWatchedItem();
            result.setName(DMServerRepositoryFolderDialog20.this.getNameTextField().getText());
            result.setPath(DMServerRepositoryFolderDialog20.this.getPathTextField().getText());
            result.setWatchedInterval(StringUtil.nullize((String)DMServerRepositoryFolderDialog20.this.getWatchedIntervalTextField().getText()));
            return result;
        }

        @Override
        public JRadioButton getRadioButton() {
            return DMServerRepositoryFolderDialog20.this.getWatchedRadioButton();
        }

        public String getText(JTextField component) {
            return DMServerRepositoryFolderDialog20.this.getParent().getParent().getPathResolver().path2Absolute(component.getText());
        }

        public void setText(JTextField component, @NotNull String text) {
            if (text == null) {
                WatchedBehavior.$$$reportNull$$$0(0);
            }
            component.setText(DMServerRepositoryFolderDialog20.this.getParent().getParent().getPathResolver().path2Relative(text));
        }

        @Override
        protected Class<DMServerRepositoryWatchedItem> getItemClass() {
            return DMServerRepositoryWatchedItem.class;
        }

        @Override
        protected void doLoad(DMServerRepositoryWatchedItem item) {
            DMServerRepositoryFolderDialog20.this.getNameTextField().setText(item.getName());
            DMServerRepositoryFolderDialog20.this.getPathTextField().setText(item.getPath());
            DMServerRepositoryFolderDialog20.this.getWatchedIntervalTextField().setText(item.getWatchedInterval());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dmserver/integration/DMServerRepositoryFolderDialog20$WatchedBehavior", "setText"));
        }
    }

    private static abstract class Behavior<T extends DMServerRepositoryItem20Base>
    implements TextComponentAccessor<JTextField> {
        private Behavior() {
        }

        public abstract void activate();

        @Nullable
        public abstract T createItem();

        public abstract JRadioButton getRadioButton();

        public boolean load(DMServerRepositoryItem20Base item) {
            if (this.getItemClass().isInstance(item)) {
                this.doLoad((DMServerRepositoryItem20Base)this.getItemClass().cast(item));
                return true;
            }
            return false;
        }

        protected abstract Class<T> getItemClass();

        protected abstract void doLoad(T var1);
    }
}

