/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.integration;

import com.google.common.base.CharMatcher;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;

public class WildcardsFinder {
    private static final CharMatcher WILDCARDS_MATCHER = CharMatcher.anyOf((CharSequence)"*{}");
    private final String myPath;
    private final String myWildcards;

    public WildcardsFinder(String text) {
        int iWildcard = WILDCARDS_MATCHER.indexIn((CharSequence)text);
        if (iWildcard == -1) {
            this.myPath = FileUtil.toSystemIndependentName((String)text);
            this.myWildcards = "";
        } else {
            String noWildcardChars = FileUtil.toSystemIndependentName((String)text.substring(0, iWildcard));
            int iLastPart = noWildcardChars.lastIndexOf(47);
            this.myPath = iLastPart == -1 ? "" : noWildcardChars.substring(0, iLastPart);
            this.myWildcards = iLastPart == -1 ? text : text.substring(iLastPart + 1);
        }
    }

    public String getPath() {
        return this.myPath;
    }

    public String getWildcards() {
        return this.myWildcards;
    }

    public boolean hasWildcards() {
        return !StringUtil.isEmpty((String)this.myWildcards);
    }
}

