/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.intention;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dmserver.artifacts.ManifestManager;
import com.intellij.dmserver.artifacts.ManifestUpdater;
import com.intellij.dmserver.editor.AvailableBundlesProvider;
import com.intellij.dmserver.editor.ExportedUnit;
import com.intellij.dmserver.editor.ExportedUnitImpl;
import com.intellij.dmserver.editor.UnitsCollector;
import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.dmserver.intention.UnitResolver;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.osgi.framework.Version;

public class PackageResolver
extends UnitResolver {
    @Override
    public String getHeaderName() {
        return "Import-Package";
    }

    @Override
    @Nls
    protected String getProblemMessage(String unitName) {
        return DmServerBundle.message("UnknownImportedPackageInspection.problem.message.unknown-package", unitName);
    }

    @Override
    protected UnitsCollector getUnitsCollector(AvailableBundlesProvider provider) {
        return provider.getPackagesCollector();
    }

    @Override
    protected void registerProblem(ProblemsHolder problemsHolder, HeaderValuePart headerValue, TextRange textRange, String unitName) {
        ManifestManager.FileWrapper manifestWrapper;
        Module module = PackageResolver.findPackageBundleModule(problemsHolder.getProject(), unitName);
        if (module != null && (manifestWrapper = ManifestManager.getBundleInstance().findManifest(module)) != null) {
            problemsHolder.registerProblem((PsiElement)headerValue, textRange, DmServerBundle.message("PackageResolver.problem.message.package-not-exported", unitName), new LocalQuickFix[]{new ExportPackageQuickFix(unitName, manifestWrapper.getFile())});
            return;
        }
        super.registerProblem(problemsHolder, headerValue, textRange, unitName);
    }

    private static Module findPackageBundleModule(Project project, String unitName) {
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project).findPackage(unitName);
        if (psiPackage == null) {
            return null;
        }
        for (Module module : ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(DMBundleFacet.ID)) {
            PsiDirectory[] directories = psiPackage.getDirectories(module.getModuleScope(false));
            if (directories.length == 0) continue;
            return module;
        }
        return null;
    }

    private static class ExportPackageQuickFix
    implements LocalQuickFix {
        private final String myPackageName;
        private final ManifestFile myManifest;

        private ExportPackageQuickFix(String packageName, ManifestFile manifest) {
            this.myPackageName = packageName;
            this.myManifest = manifest;
        }

        @NotNull
        public String getName() {
            String string = DmServerBundle.message("PackageResolver.ExportPackageQuickFix.name", new Object[0]);
            if (string == null) {
                ExportPackageQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = DmServerBundle.message("PackageResolver.ExportPackageQuickFix.family.name", new Object[0]);
            if (string == null) {
                ExportPackageQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ExportPackageQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ExportPackageQuickFix.$$$reportNull$$$0(3);
            }
            ArrayList<ExportedUnit> exportedPackages = new ArrayList<ExportedUnit>(AvailableBundlesProvider.getExportedPackages((PsiFile)this.myManifest));
            exportedPackages.add(new ExportedUnitImpl(this.myPackageName, Version.emptyVersion.toString()));
            ManifestUpdater manifestUpdater = new ManifestUpdater(this.myManifest);
            StringBuilder headerValue = new StringBuilder();
            for (ExportedUnit exportedPackage : exportedPackages) {
                if (headerValue.length() > 0) {
                    headerValue.append(",\n ");
                }
                headerValue.append(exportedPackage.getSymbolicName());
                if (Version.emptyVersion.equals((Object)exportedPackage.getVersion())) continue;
                headerValue.append(";");
                headerValue.append("version");
                headerValue.append("=\"");
                headerValue.append(exportedPackage.getVersion().toString());
                headerValue.append("\"");
            }
            manifestUpdater.updateHeader("Export-Package", headerValue.toString(), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dmserver/intention/PackageResolver$ExportPackageQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dmserver/intention/PackageResolver$ExportPackageQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

