/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.intention;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dmserver.editor.AvailableBundlesProvider;
import com.intellij.dmserver.editor.UnitsCollector;
import com.intellij.dmserver.libraries.LibrariesDialogCreator;
import com.intellij.dmserver.manifest.HeaderValuePartProcessor;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;

public abstract class UnitResolver
implements HeaderValuePartProcessor<ProblemsHolder> {
    @NonNls
    private static final Pattern TRIM_PATTERN = Pattern.compile("(\\s*)(\\S*?)\\s*");

    @Override
    public void process(HeaderValuePart headerValue, ProblemsHolder problemsHolder) {
        Matcher trimMatcher = TRIM_PATTERN.matcher(headerValue.getText());
        if (!trimMatcher.matches()) {
            return;
        }
        int start = trimMatcher.group(1).length();
        String unitName = trimMatcher.group(2);
        int length = unitName.length();
        if (length == 0) {
            return;
        }
        if (this.getUnitsCollector(AvailableBundlesProvider.getInstance(headerValue.getProject())).isUnitAvailable(unitName)) {
            return;
        }
        this.registerProblem(problemsHolder, headerValue, new TextRange(start, start + length), unitName);
    }

    protected void registerProblem(ProblemsHolder problemsHolder, HeaderValuePart headerValue, TextRange textRange, String unitName) {
        LocalQuickFix[] localQuickFixArray;
        if (LibrariesDialogCreator.isDialogAvailable(headerValue.getProject())) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = new DownloadUnitQuickFix(unitName);
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] quickFixes = localQuickFixArray;
        problemsHolder.registerProblem((PsiElement)headerValue, textRange, this.getProblemMessage(unitName), quickFixes);
    }

    @Nls
    protected abstract String getProblemMessage(String var1);

    protected abstract UnitsCollector getUnitsCollector(AvailableBundlesProvider var1);

    private static class DownloadUnitQuickFix
    implements LocalQuickFix {
        private final String myPackageName;

        private DownloadUnitQuickFix(String unitName) {
            this.myPackageName = unitName;
        }

        @NotNull
        public String getName() {
            String string = DmServerBundle.message("UnknownImportedPackageInspection.DownloadQuickFix.name", new Object[0]);
            if (string == null) {
                DownloadUnitQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = DmServerBundle.message("UnknownImportedPackageInspection.DownloadPackageQuickFix.family.name", new Object[0]);
            if (string == null) {
                DownloadUnitQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                DownloadUnitQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                DownloadUnitQuickFix.$$$reportNull$$$0(3);
            }
            LibrariesDialogCreator.showDialog(project, this.myPackageName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dmserver/intention/UnitResolver$DownloadUnitQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dmserver/intention/UnitResolver$DownloadUnitQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

