/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.obr;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.integration.RepositoryPattern;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadTargetEditor {
    private JComboBox myRepositoryItemComboBox;
    private TextFieldWithBrowseButton mySubFolderField;
    private JPanel myMainPanel;
    private FileChooserDescriptor myFileChooserDescriptor;
    private boolean myChooseSubFolder;
    private VirtualFile myBaseDir;

    public DownloadTargetEditor() {
        this.$$$setupUI$$$();
        this.myRepositoryItemComboBox.setRenderer(new ListCellRendererWrapper<RepositoryPattern>(){

            public void customize(JList list, RepositoryPattern value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getSource().getPath());
                }
            }
        });
        this.myRepositoryItemComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DownloadTargetEditor.this.doSelectRepositoryItem();
                }
            }
        });
        this.myFileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myFileChooserDescriptor.withTreeRootVisible(true);
        this.mySubFolderField.addBrowseFolderListener(DmServerBundle.message("DownloadTargetEditor.browse.title", new Object[0]), DmServerBundle.message("DownloadTargetEditor.browse.description", new Object[0]), null, this.myFileChooserDescriptor, (TextComponentAccessor)new TextComponentAccessor<JTextField>(){

            public String getText(JTextField component) {
                return DownloadTargetEditor.this.getBaseDir().getPath() + "/" + component.getText();
            }

            public void setText(JTextField component, @NotNull String text) {
                if (text == null) {
                    3.$$$reportNull$$$0(0);
                }
                component.setText(FileUtil.getRelativePath((String)DownloadTargetEditor.this.getBaseDir().getPath(), (String)FileUtil.toSystemIndependentName((String)text), (char)'/'));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dmserver/libraries/obr/DownloadTargetEditor$3", "setText"));
            }
        });
    }

    private VirtualFile getBaseDir() {
        return this.myBaseDir;
    }

    @Nullable
    public VirtualFile getTargetDir() {
        VirtualFile result = this.getBaseDir();
        if (this.myChooseSubFolder) {
            result = result.findFileByRelativePath(this.mySubFolderField.getText());
        }
        return result;
    }

    public void init(DMServerInstallation installation) {
        this.myRepositoryItemComboBox.removeAllItems();
        for (RepositoryPattern repositoryPattern : installation.collectRepositoryPatterns()) {
            this.myRepositoryItemComboBox.addItem(repositoryPattern);
        }
        this.doSelectRepositoryItem();
    }

    private void doSelectRepositoryItem() {
        RepositoryPattern repositoryPattern = this.getSelectedRepositoryPattern();
        boolean hasRepositoryPattern = repositoryPattern != null;
        this.myBaseDir = hasRepositoryPattern ? repositoryPattern.findBaseDir() : null;
        this.myChooseSubFolder = this.myBaseDir != null && repositoryPattern.hasDirPatterns();
        this.mySubFolderField.setEnabled(this.myChooseSubFolder);
        this.mySubFolderField.setText("");
        if (this.myChooseSubFolder) {
            this.myFileChooserDescriptor.setRoots(new VirtualFile[]{this.myBaseDir});
        }
    }

    private RepositoryPattern getSelectedRepositoryPattern() {
        return (RepositoryPattern)this.myRepositoryItemComboBox.getSelectedItem();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRepositoryItemComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(100, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySubFolderField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 0, null, new Dimension(100, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DownloadTargetEditor.download.to"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DownloadTargetEditor.subfolder"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

